/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.jruby;

import java.io.IOException;
import org.jruby.RubyException;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.jruby.JRubyScriptUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JRubyScriptFactory
implements ScriptFactory,
BeanClassLoaderAware {
    private final String scriptSourceLocator;
    private final Class[] scriptInterfaces;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public JRubyScriptFactory(String scriptSourceLocator, Class[] scriptInterfaces) {
        Assert.hasText((String)scriptSourceLocator, (String)"'scriptSourceLocator' must not be empty");
        Assert.notEmpty((Object[])scriptInterfaces, (String)"'scriptInterfaces' must not be empty");
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    public Class[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    public boolean requiresConfigInterface() {
        return true;
    }

    public Object getScriptedObject(ScriptSource scriptSource, Class[] actualInterfaces) throws IOException, ScriptCompilationException {
        try {
            return JRubyScriptUtils.createJRubyObject(scriptSource.getScriptAsString(), actualInterfaces, this.beanClassLoader);
        }
        catch (RaiseException ex) {
            RubyException rubyEx = ex.getException();
            String msg = rubyEx != null && rubyEx.message != null ? rubyEx.message.toString() : "Unexpected JRuby error";
            throw new ScriptCompilationException(scriptSource, msg, ex);
        }
        catch (JumpException ex) {
            throw new ScriptCompilationException(scriptSource, (Throwable)ex);
        }
    }

    public Class getScriptedObjectType(ScriptSource scriptSource) throws IOException, ScriptCompilationException {
        return null;
    }

    public String toString() {
        return "JRubyScriptFactory: script source locator [" + this.scriptSourceLocator + "]";
    }
}

