/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.instrument.InstrumentationSavingAgent;
import org.springframework.instrument.classloading.AbstractLoadTimeWeaver;

public class InstrumentationLoadTimeWeaver
extends AbstractLoadTimeWeaver {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public ClassLoader getInstrumentableClassLoader() {
        return this.getContextClassLoader();
    }

    public void addTransformer(ClassFileTransformer transformer) {
        Instrumentation instrumentation;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Installing " + transformer));
        }
        if ((instrumentation = InstrumentationSavingAgent.getInstrumentation()) == null) {
            throw new UnsupportedOperationException("Must start with Java agent to use InstrumentationLoadTimeWeaver. See Spring documentation.");
        }
        instrumentation.addTransformer(transformer);
    }
}

