/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.quartz.DelegatingJob;

public class JobDetailBean
extends JobDetail
implements BeanNameAware,
ApplicationContextAware,
InitializingBean {
    private Class<?> actualJobClass;
    private String beanName;
    private ApplicationContext applicationContext;
    private String applicationContextJobDataKey;

    public void setJobClass(Class jobClass) {
        if (jobClass != null && !Job.class.isAssignableFrom(jobClass)) {
            super.setJobClass(DelegatingJob.class);
            this.actualJobClass = jobClass;
        } else {
            super.setJobClass(jobClass);
        }
    }

    public Class getJobClass() {
        return this.actualJobClass != null ? this.actualJobClass : super.getJobClass();
    }

    public void setJobDataAsMap(Map jobDataAsMap) {
        this.getJobDataMap().putAll(jobDataAsMap);
    }

    public void setJobListenerNames(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.addJobListener(names[i]);
        }
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setApplicationContextJobDataKey(String applicationContextJobDataKey) {
        this.applicationContextJobDataKey = applicationContextJobDataKey;
    }

    public void afterPropertiesSet() {
        if (this.getName() == null) {
            this.setName(this.beanName);
        }
        if (this.getGroup() == null) {
            this.setGroup("DEFAULT");
        }
        if (this.applicationContextJobDataKey != null) {
            if (this.applicationContext == null) {
                throw new IllegalStateException("JobDetailBean needs to be set up in an ApplicationContext to be able to handle an 'applicationContextJobDataKey'");
            }
            this.getJobDataMap().put((Object)this.applicationContextJobDataKey, (Object)this.applicationContext);
        }
    }
}

