/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.format.support;

import java.beans.PropertyEditor;
import org.springframework.binding.format.support.AbstractFormatter;
import org.springframework.util.Assert;

public class PropertyEditorFormatter
extends AbstractFormatter {
    private PropertyEditor propertyEditor;

    public PropertyEditorFormatter(PropertyEditor propertyEditor) {
        Assert.notNull((Object)propertyEditor, (String)"Property editor is required");
        this.propertyEditor = propertyEditor;
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    protected String doFormatValue(Object value) {
        this.propertyEditor.setValue(value);
        return this.propertyEditor.getAsText();
    }

    protected Object doParseValue(String formattedValue, Class targetClass) {
        this.propertyEditor.setAsText(formattedValue);
        return this.propertyEditor.getValue();
    }
}

