/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import java.util.LinkedList;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserException;
import org.springframework.binding.expression.SettableExpression;
import org.springframework.binding.expression.support.CompositeStringExpression;
import org.springframework.binding.expression.support.StaticExpression;
import org.springframework.util.StringUtils;

public abstract class AbstractExpressionParser
implements ExpressionParser {
    private static final String DEFAULT_EXPRESSION_PREFIX = "${";
    private static final String DEFAULT_EXPRESSION_SUFFIX = "}";
    private String expressionPrefix = "${";
    private String expressionSuffix = "}";

    public String getExpressionPrefix() {
        return this.expressionPrefix;
    }

    public void setExpressionPrefix(String expressionPrefix) {
        this.expressionPrefix = expressionPrefix;
    }

    public String getExpressionSuffix() {
        return this.expressionSuffix;
    }

    public void setExpressionSuffix(String expressionSuffix) {
        this.expressionSuffix = expressionSuffix;
    }

    public boolean isDelimitedExpression(String expressionString) {
        int prefixIndex = expressionString.indexOf(this.getExpressionPrefix());
        if (prefixIndex == -1) {
            return false;
        }
        int suffixIndex = expressionString.indexOf(this.getExpressionSuffix(), prefixIndex);
        if (suffixIndex == -1) {
            return false;
        }
        return suffixIndex != prefixIndex + this.getExpressionPrefix().length();
    }

    public final Expression parseExpression(String expressionString) throws ParserException {
        Expression[] expressions = this.parseExpressions(expressionString);
        if (expressions.length == 1) {
            return expressions[0];
        }
        return new CompositeStringExpression(expressions);
    }

    public final SettableExpression parseSettableExpression(String expressionString) throws ParserException, UnsupportedOperationException {
        if ((expressionString = expressionString.trim()).startsWith(this.getExpressionPrefix()) && expressionString.endsWith(this.getExpressionSuffix())) {
            expressionString = expressionString.substring(this.getExpressionPrefix().length(), expressionString.length() - this.getExpressionSuffix().length());
        }
        return this.doParseSettableExpression(expressionString);
    }

    private Expression[] parseExpressions(String expressionString) throws ParserException {
        LinkedList<Expression> expressions = new LinkedList<Expression>();
        if (StringUtils.hasText((String)expressionString)) {
            int startIdx = 0;
            while (startIdx < expressionString.length()) {
                int prefixIndex = expressionString.indexOf(this.getExpressionPrefix(), startIdx);
                if (prefixIndex >= startIdx) {
                    int nextPrefixIndex;
                    int suffixIndex;
                    if (prefixIndex > startIdx) {
                        expressions.add(new StaticExpression(expressionString.substring(startIdx, prefixIndex)));
                        startIdx = prefixIndex;
                    }
                    if ((suffixIndex = (nextPrefixIndex = expressionString.indexOf(this.getExpressionPrefix(), prefixIndex + this.getExpressionPrefix().length())) == -1 ? expressionString.lastIndexOf(this.getExpressionSuffix()) : expressionString.lastIndexOf(this.getExpressionSuffix(), nextPrefixIndex)) < prefixIndex + this.getExpressionPrefix().length()) {
                        throw new ParserException(expressionString, "No ending suffix '" + this.getExpressionSuffix() + "' for expression starting at character " + prefixIndex + ": " + expressionString.substring(prefixIndex), null);
                    }
                    if (suffixIndex == prefixIndex + this.getExpressionPrefix().length()) {
                        throw new ParserException(expressionString, "No expression defined within delimiter '" + this.getExpressionPrefix() + this.getExpressionSuffix() + "' at character " + prefixIndex, null);
                    }
                    String expr = expressionString.substring(prefixIndex + this.getExpressionPrefix().length(), suffixIndex);
                    expressions.add(this.doParseExpression(expr));
                    startIdx = suffixIndex + 1;
                    continue;
                }
                if (startIdx == 0) {
                    expressions.add(this.doParseExpression(expressionString));
                } else {
                    expressions.add(new StaticExpression(expressionString.substring(startIdx)));
                }
                startIdx = expressionString.length();
            }
        } else {
            expressions.add(new StaticExpression(expressionString));
        }
        return expressions.toArray(new Expression[expressions.size()]);
    }

    protected abstract Expression doParseExpression(String var1) throws ParserException;

    protected abstract SettableExpression doParseSettableExpression(String var1) throws ParserException, UnsupportedOperationException;
}

