/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.Converter;
import org.springframework.binding.convert.support.ConversionServiceAware;
import org.springframework.binding.convert.support.NoOpConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class GenericConversionService
implements ConversionService {
    private Map sourceClassConverters = new HashMap();
    private Map aliasMap = new HashMap();
    private ConversionService parent;
    static /* synthetic */ Class class$org$springframework$binding$convert$Converter;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;

    public ConversionService getParent() {
        return this.parent;
    }

    public void setParent(ConversionService parent) {
        this.parent = parent;
    }

    public void addConverter(Converter converter) {
        Class[] sourceClasses = converter.getSourceClasses();
        Class[] targetClasses = converter.getTargetClasses();
        for (int i = 0; i < sourceClasses.length; ++i) {
            Class sourceClass = sourceClasses[i];
            HashMap<Class, Converter> sourceMap = (HashMap<Class, Converter>)this.sourceClassConverters.get(sourceClass);
            if (sourceMap == null) {
                sourceMap = new HashMap<Class, Converter>();
                this.sourceClassConverters.put(sourceClass, sourceMap);
            }
            for (int j = 0; j < targetClasses.length; ++j) {
                Class targetClass = targetClasses[j];
                sourceMap.put(targetClass, converter);
            }
        }
        if (converter instanceof ConversionServiceAware) {
            ((ConversionServiceAware)((Object)converter)).setConversionService(this);
        }
    }

    public void addConverters(Converter[] converters) {
        for (int i = 0; i < converters.length; ++i) {
            this.addConverter(converters[i]);
        }
    }

    public void addConverter(Converter converter, String alias) {
        this.aliasMap.put(alias, converter);
        this.addConverter(converter);
    }

    public void addAlias(String alias, Class targetType) {
        this.aliasMap.put(alias, targetType);
    }

    public void addDefaultAlias(Class targetType) {
        this.addAlias(StringUtils.uncapitalize((String)ClassUtils.getShortName((Class)targetType)), targetType);
    }

    public ConversionExecutor getConversionExecutor(Class sourceClass, Class targetClass) throws ConversionException {
        Assert.notNull((Object)sourceClass, (String)"The source class to convert from is required");
        Assert.notNull((Object)targetClass, (String)"The target class to convert to is required");
        if (this.sourceClassConverters == null || this.sourceClassConverters.isEmpty()) {
            throw new IllegalStateException("No converters have been added to this service's registry");
        }
        if (targetClass.isAssignableFrom(sourceClass)) {
            return new ConversionExecutor(sourceClass, targetClass, new NoOpConverter(sourceClass, targetClass));
        }
        Map sourceTargetConverters = this.findConvertersForSource(sourceClass);
        Converter converter = this.findTargetConverter(sourceTargetConverters, targetClass);
        if (converter != null) {
            return new ConversionExecutor(sourceClass, targetClass, converter);
        }
        if (this.parent != null) {
            return this.parent.getConversionExecutor(sourceClass, targetClass);
        }
        throw new ConversionException(sourceClass, targetClass, "No converter registered to convert from sourceClass '" + sourceClass + "' to target class '" + targetClass + "'");
    }

    public ConversionExecutor getConversionExecutorByTargetAlias(Class sourceClass, String alias) throws IllegalArgumentException {
        Assert.notNull((Object)sourceClass, (String)"The source class to convert from is required");
        Assert.hasText((String)alias, (String)"The target alias is required and must either be a type alias (e.g 'boolean') or a generic converter alias (e.g. 'bean') ");
        Object targetType = this.aliasMap.get(alias);
        if (targetType == null) {
            if (this.parent != null) {
                return this.parent.getConversionExecutorByTargetAlias(sourceClass, alias);
            }
            return null;
        }
        if (targetType instanceof Class) {
            return this.getConversionExecutor(sourceClass, (Class)targetType);
        }
        Assert.isInstanceOf((Class)(class$org$springframework$binding$convert$Converter == null ? (class$org$springframework$binding$convert$Converter = GenericConversionService.class$("org.springframework.binding.convert.Converter")) : class$org$springframework$binding$convert$Converter), targetType, (String)"Not a converter: ");
        Converter conv = (Converter)targetType;
        return new ConversionExecutor(sourceClass, class$java$lang$Object == null ? (class$java$lang$Object = GenericConversionService.class$("java.lang.Object")) : class$java$lang$Object, conv);
    }

    public ConversionExecutor[] getConversionExecutorsForSource(Class sourceClass) {
        Assert.notNull((Object)sourceClass, (String)"The source class to convert from is required");
        Map sourceTargetConverters = this.findConvertersForSource(sourceClass);
        if (sourceTargetConverters.isEmpty()) {
            if (this.parent != null) {
                return this.parent.getConversionExecutorsForSource(sourceClass);
            }
            return new ConversionExecutor[0];
        }
        HashSet<ConversionExecutor> executors = new HashSet<ConversionExecutor>();
        if (this.parent != null) {
            executors.addAll(Arrays.asList(this.parent.getConversionExecutorsForSource(sourceClass)));
        }
        Iterator it = sourceTargetConverters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            executors.add(new ConversionExecutor(sourceClass, (Class)entry.getKey(), (Converter)entry.getValue()));
        }
        return executors.toArray(new ConversionExecutor[executors.size()]);
    }

    public Class getClassByAlias(String alias) {
        Assert.hasText((String)alias, (String)"The alias is required and must be a type alias (e.g 'boolean')");
        Object clazz = this.aliasMap.get(alias);
        if (clazz != null) {
            Assert.isInstanceOf((Class)(class$java$lang$Class == null ? (class$java$lang$Class = GenericConversionService.class$("java.lang.Class")) : class$java$lang$Class), clazz, (String)("Not a Class alias '" + alias + "': "));
            return (Class)clazz;
        }
        if (this.parent != null) {
            return this.parent.getClassByAlias(alias);
        }
        return null;
    }

    private Map findConvertersForSource(Class sourceClass) {
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(sourceClass);
        while (!classQueue.isEmpty()) {
            sourceClass = (Class)classQueue.removeLast();
            Map sourceTargetConverters = (Map)this.sourceClassConverters.get(sourceClass);
            if (sourceTargetConverters != null && !sourceTargetConverters.isEmpty()) {
                return sourceTargetConverters;
            }
            if (!sourceClass.isInterface() && sourceClass.getSuperclass() != null) {
                classQueue.addFirst(sourceClass.getSuperclass());
            }
            Class<?>[] interfaces = sourceClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                classQueue.addFirst(interfaces[i]);
            }
        }
        return Collections.EMPTY_MAP;
    }

    private Converter findTargetConverter(Map sourceTargetConverters, Class targetClass) {
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(targetClass);
        while (!classQueue.isEmpty()) {
            targetClass = (Class)classQueue.removeLast();
            Converter converter = (Converter)sourceTargetConverters.get(targetClass);
            if (converter != null) {
                return converter;
            }
            if (!targetClass.isInterface() && targetClass.getSuperclass() != null) {
                classQueue.addFirst(targetClass.getSuperclass());
            }
            Class<?>[] interfaces = targetClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                classQueue.addFirst(interfaces[i]);
            }
        }
        return null;
    }

    protected Map getSourceClassConverters() {
        return this.sourceClassConverters;
    }

    protected Map getAliasMap() {
        return this.aliasMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

