/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.method.InvalidMethodKeyException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MethodKey
implements Serializable {
    private Class declaredType;
    private String methodName;
    private Class[] parameterTypes;
    private transient Method method;
    private static final Map primitiveWrapperTypeMap = new HashMap(8);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public MethodKey(Class declaredType, String methodName, Class[] parameterTypes) {
        Assert.notNull((Object)declaredType, (String)"The method's declared type is required");
        Assert.notNull((Object)methodName, (String)"The method name is required");
        this.declaredType = declaredType;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public Class getDeclaredType() {
        return this.declaredType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Method getMethod() throws InvalidMethodKeyException {
        if (this.method == null) {
            this.method = this.resolveMethod();
        }
        return this.method;
    }

    protected Method resolveMethod() throws InvalidMethodKeyException {
        try {
            return this.declaredType.getMethod(this.methodName, this.parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Method method = this.findMethodConsiderAssignableParameterTypes();
            if (method != null) {
                return method;
            }
            throw new InvalidMethodKeyException(this, e);
        }
    }

    protected Method findMethodConsiderAssignableParameterTypes() {
        Method[] candidateMethods = this.getDeclaredType().getMethods();
        for (int i = 0; i < candidateMethods.length; ++i) {
            Class<?>[] candidateParameterTypes;
            if (!candidateMethods[i].getName().equals(this.methodName) || (candidateParameterTypes = candidateMethods[i].getParameterTypes()).length != this.parameterTypes.length) continue;
            int numberOfCorrectArguments = 0;
            for (int j = 0; j < candidateParameterTypes.length; ++j) {
                Class<?> candidateType = candidateParameterTypes[j];
                Class parameterType = this.parameterTypes[j];
                if (parameterType != null) {
                    if (!MethodKey.isAssignable(candidateType, parameterType)) continue;
                    ++numberOfCorrectArguments;
                    continue;
                }
                ++numberOfCorrectArguments;
            }
            if (numberOfCorrectArguments != this.parameterTypes.length) continue;
            return candidateMethods[i];
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodKey)) {
            return false;
        }
        MethodKey other = (MethodKey)obj;
        return this.declaredType.equals(other.declaredType) && this.methodName.equals(other.methodName) && this.parameterTypesEqual(other.parameterTypes);
    }

    private boolean parameterTypesEqual(Class[] other) {
        if (this.parameterTypes == other) {
            return true;
        }
        if (this.parameterTypes.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (ObjectUtils.nullSafeEquals((Object)this.parameterTypes[i], (Object)other[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.declaredType.hashCode() + this.methodName.hashCode() + this.parameterTypesHash();
    }

    private int parameterTypesHash() {
        if (this.parameterTypes == null) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            Class parameterType = this.parameterTypes[i];
            if (parameterType == null) continue;
            hash += this.parameterTypes[i].hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.methodName + "(" + this.parameterTypesString() + ")";
    }

    private String parameterTypesString() {
        StringBuffer parameterTypesString = new StringBuffer();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (this.parameterTypes[i] == null) {
                parameterTypesString.append("<any>");
            } else {
                parameterTypesString.append(ClassUtils.getShortName((Class)this.parameterTypes[i]));
            }
            if (i >= this.parameterTypes.length - 1) continue;
            parameterTypesString.append(',');
        }
        return parameterTypesString.toString();
    }

    private static boolean isAssignable(Class targetType, Class valueType) {
        return targetType.isAssignableFrom(valueType) || targetType.equals(primitiveWrapperTypeMap.get(valueType));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveWrapperTypeMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodKey.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = MethodKey.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Character == null ? (class$java$lang$Character = MethodKey.class$("java.lang.Character")) : class$java$lang$Character, Character.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Double == null ? (class$java$lang$Double = MethodKey.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Float == null ? (class$java$lang$Float = MethodKey.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = MethodKey.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Long == null ? (class$java$lang$Long = MethodKey.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Short == null ? (class$java$lang$Short = MethodKey.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE);
    }
}

