/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class TypeConverterDelegate {
    private static final Log logger = LogFactory.getLog(TypeConverterDelegate.class);
    private final PropertyEditorRegistrySupport propertyEditorRegistry;
    private final @Nullable Object targetObject;

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry) {
        this(propertyEditorRegistry, null);
    }

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry, @Nullable Object targetObject) {
        this.propertyEditorRegistry = propertyEditorRegistry;
        this.targetObject = targetObject;
    }

    public <T> @Nullable T convertIfNecessary(@Nullable String propertyName, @Nullable Object oldValue, Object newValue, @Nullable Class<T> requiredType) throws IllegalArgumentException {
        return this.convertIfNecessary(propertyName, oldValue, newValue, requiredType, TypeDescriptor.valueOf(requiredType));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> @Nullable T convertIfNecessary(@Nullable String propertyName, @Nullable Object oldValue, @Nullable Object newValue, @Nullable Class<T> requiredType, @Nullable TypeDescriptor typeDescriptor) throws IllegalArgumentException {
        boolean standardConversion;
        Object convertedValue;
        ConversionFailedException conversionAttemptEx;
        PropertyEditor editor;
        block37: {
            ConversionService conversionService;
            block42: {
                block38: {
                    block41: {
                        String text;
                        block36: {
                            block40: {
                                block39: {
                                    TypeDescriptor sourceTypeDesc;
                                    editor = this.propertyEditorRegistry.findCustomEditor(requiredType, propertyName);
                                    conversionAttemptEx = null;
                                    conversionService = this.propertyEditorRegistry.getConversionService();
                                    if (editor == null && conversionService != null && newValue != null && typeDescriptor != null && conversionService.canConvert(sourceTypeDesc = TypeDescriptor.forObject((Object)newValue), typeDescriptor)) {
                                        try {
                                            return (T)conversionService.convert((Object)newValue, sourceTypeDesc, typeDescriptor);
                                        }
                                        catch (ConversionFailedException ex) {
                                            conversionAttemptEx = ex;
                                        }
                                    }
                                    convertedValue = newValue;
                                    if (editor != null || requiredType != null && !ClassUtils.isAssignableValue(requiredType, (Object)convertedValue)) {
                                        TypeDescriptor elementTypeDesc;
                                        if (typeDescriptor != null && requiredType != null && Collection.class.isAssignableFrom(requiredType) && (elementTypeDesc = typeDescriptor.getElementTypeDescriptor()) != null) {
                                            Class elementType = elementTypeDesc.getType();
                                            if (convertedValue instanceof String) {
                                                String text2 = (String)convertedValue;
                                                if (Class.class == elementType || Enum.class.isAssignableFrom(elementType)) {
                                                    convertedValue = StringUtils.commaDelimitedListToStringArray((String)text2);
                                                }
                                                if (editor == null && String.class != elementType) {
                                                    editor = this.findDefaultEditor((Class<?>)elementType.arrayType());
                                                }
                                            }
                                        }
                                        if (editor == null) {
                                            editor = this.findDefaultEditor(requiredType);
                                        }
                                        convertedValue = this.doConvertValue(oldValue, convertedValue, requiredType, editor);
                                    }
                                    standardConversion = false;
                                    if (requiredType == null) break block37;
                                    if (convertedValue == null) break block38;
                                    if (Object.class == requiredType) {
                                        return (T)convertedValue;
                                    }
                                    if (requiredType.isArray()) {
                                        if (convertedValue instanceof String) {
                                            String text3 = (String)convertedValue;
                                            if (Enum.class.isAssignableFrom((Class<?>)requiredType.componentType())) {
                                                convertedValue = StringUtils.commaDelimitedListToStringArray((String)text3);
                                            }
                                        }
                                        return (T)this.convertToTypedArray(convertedValue, propertyName, (Class<?>)requiredType.componentType());
                                    }
                                    if (!convertedValue.getClass().isArray()) break block39;
                                    if (Collection.class.isAssignableFrom(requiredType)) {
                                        convertedValue = this.convertToTypedCollection(CollectionUtils.arrayToList((Object)convertedValue), propertyName, requiredType, typeDescriptor);
                                        standardConversion = true;
                                        break block40;
                                    } else if (Array.getLength(convertedValue) == 1) {
                                        convertedValue = Array.get(convertedValue, 0);
                                        standardConversion = true;
                                    }
                                    break block40;
                                }
                                if (convertedValue instanceof Collection) {
                                    Collection coll = (Collection)convertedValue;
                                    convertedValue = this.convertToTypedCollection(coll, propertyName, requiredType, typeDescriptor);
                                    standardConversion = true;
                                } else if (convertedValue instanceof Map) {
                                    Map map = (Map)convertedValue;
                                    convertedValue = this.convertToTypedMap(map, propertyName, requiredType, typeDescriptor);
                                    standardConversion = true;
                                }
                            }
                            if (String.class == requiredType && ClassUtils.isPrimitiveOrWrapper(convertedValue.getClass())) {
                                return (T)convertedValue.toString();
                            }
                            if (!(convertedValue instanceof String)) break block41;
                            text = (String)convertedValue;
                            if (requiredType.isInstance(convertedValue)) break block41;
                            if (conversionAttemptEx == null && !requiredType.isInterface() && !requiredType.isEnum()) {
                                try {
                                    Constructor<T> strCtor = requiredType.getConstructor(String.class);
                                    return BeanUtils.instantiateClass(strCtor, convertedValue);
                                }
                                catch (NoSuchMethodException ex) {
                                    if (logger.isTraceEnabled()) {
                                        logger.trace((Object)("No String constructor found on type [" + requiredType.getName() + "]"), (Throwable)ex);
                                    }
                                }
                                catch (Exception ex) {
                                    if (!logger.isDebugEnabled()) break block36;
                                    logger.debug((Object)("Construction via String failed for type [" + requiredType.getName() + "]"), (Throwable)ex);
                                }
                            }
                        }
                        String trimmedValue = text.trim();
                        if (requiredType.isEnum() && trimmedValue.isEmpty()) {
                            return null;
                        }
                        convertedValue = this.attemptToConvertStringToEnum(requiredType, trimmedValue, convertedValue);
                        standardConversion = true;
                        break block42;
                    }
                    if (convertedValue instanceof Number) {
                        Number num = (Number)convertedValue;
                        if (Number.class.isAssignableFrom(requiredType)) {
                            convertedValue = NumberUtils.convertNumberToTargetClass((Number)num, requiredType);
                            standardConversion = true;
                        }
                    }
                    break block42;
                }
                if (requiredType == Optional.class) {
                    convertedValue = Optional.empty();
                }
            }
            if (!ClassUtils.isAssignableValue(requiredType, (Object)convertedValue)) {
                TypeDescriptor sourceTypeDesc;
                if (conversionAttemptEx != null) {
                    throw conversionAttemptEx;
                }
                if (conversionService != null && typeDescriptor != null && conversionService.canConvert(sourceTypeDesc = TypeDescriptor.forObject((Object)newValue), typeDescriptor)) {
                    return (T)conversionService.convert((Object)newValue, sourceTypeDesc, typeDescriptor);
                }
                StringBuilder msg = new StringBuilder();
                msg.append("Cannot convert value of type '").append(ClassUtils.getDescriptiveType((Object)newValue));
                msg.append("' to required type '").append(ClassUtils.getQualifiedName(requiredType)).append('\'');
                if (propertyName != null) {
                    msg.append(" for property '").append(propertyName).append('\'');
                }
                if (editor != null) {
                    msg.append(": PropertyEditor [").append(editor.getClass().getName()).append("] returned inappropriate value of type '").append(ClassUtils.getDescriptiveType((Object)convertedValue)).append('\'');
                    throw new IllegalArgumentException(msg.toString());
                }
                msg.append(": no matching editors or conversion strategy found");
                throw new IllegalStateException(msg.toString());
            }
        }
        if (conversionAttemptEx != null) {
            if (editor == null && !standardConversion && requiredType != null && Object.class != requiredType) {
                throw conversionAttemptEx;
            }
            logger.debug((Object)"Original ConversionService attempt failed - ignored since PropertyEditor based conversion eventually succeeded", conversionAttemptEx);
        }
        return (T)convertedValue;
    }

    private Object attemptToConvertStringToEnum(Class<?> requiredType, String trimmedValue, Object currentConvertedValue) {
        Object convertedValue;
        block9: {
            block8: {
                int index;
                convertedValue = currentConvertedValue;
                if (Enum.class == requiredType && this.targetObject != null && (index = trimmedValue.lastIndexOf(46)) > -1) {
                    String enumType = trimmedValue.substring(0, index);
                    String fieldName = trimmedValue.substring(index + 1);
                    ClassLoader cl = this.targetObject.getClass().getClassLoader();
                    try {
                        Class enumValueType = ClassUtils.forName((String)enumType, (ClassLoader)cl);
                        Field enumField = enumValueType.getField(fieldName);
                        convertedValue = enumField.get(null);
                    }
                    catch (ClassNotFoundException ex) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Enum class [" + enumType + "] cannot be loaded"), (Throwable)ex);
                        }
                    }
                    catch (Throwable ex) {
                        if (!logger.isTraceEnabled()) break block8;
                        logger.trace((Object)("Field [" + fieldName + "] isn't an enum value for type [" + enumType + "]"), ex);
                    }
                }
            }
            if (convertedValue == currentConvertedValue) {
                try {
                    Field enumField = requiredType.getField(trimmedValue);
                    ReflectionUtils.makeAccessible((Field)enumField);
                    convertedValue = enumField.get(null);
                }
                catch (Throwable ex) {
                    if (!logger.isTraceEnabled()) break block9;
                    logger.trace((Object)("Field [" + String.valueOf(convertedValue) + "] isn't an enum value"), ex);
                }
            }
        }
        return convertedValue;
    }

    private @Nullable PropertyEditor findDefaultEditor(@Nullable Class<?> requiredType) {
        PropertyEditor editor = null;
        if (requiredType != null && (editor = this.propertyEditorRegistry.getDefaultEditor(requiredType)) == null && String.class != requiredType) {
            editor = BeanUtils.findEditorByConvention(requiredType);
        }
        return editor;
    }

    private @Nullable Object doConvertValue(@Nullable Object oldValue, @Nullable Object newValue, @Nullable Class<?> requiredType, @Nullable PropertyEditor editor) {
        Object convertedValue;
        block10: {
            convertedValue = newValue;
            if (editor != null && !(convertedValue instanceof String)) {
                try {
                    editor.setValue(convertedValue);
                    Object newConvertedValue = editor.getValue();
                    if (newConvertedValue != convertedValue) {
                        convertedValue = newConvertedValue;
                        editor = null;
                    }
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.debug((Object)("PropertyEditor [" + editor.getClass().getName() + "] does not support setValue call"), (Throwable)ex);
                }
            }
        }
        Object returnValue = convertedValue;
        if (requiredType != null && !requiredType.isArray() && convertedValue instanceof String[]) {
            Object[] array = (String[])convertedValue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Converting String array to comma-delimited String [" + String.valueOf(convertedValue) + "]"));
            }
            convertedValue = StringUtils.arrayToCommaDelimitedString((Object[])array);
        }
        if (convertedValue instanceof String) {
            String newTextValue = (String)convertedValue;
            if (editor != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Converting String to [" + String.valueOf(requiredType) + "] using property editor [" + String.valueOf(editor) + "]"));
                }
                return this.doConvertTextValue(oldValue, newTextValue, editor);
            }
            if (String.class == requiredType) {
                returnValue = convertedValue;
            }
        }
        return returnValue;
    }

    private Object doConvertTextValue(@Nullable Object oldValue, String newTextValue, PropertyEditor editor) {
        block2: {
            try {
                editor.setValue(oldValue);
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)("PropertyEditor [" + editor.getClass().getName() + "] does not support setValue call"), (Throwable)ex);
            }
        }
        editor.setAsText(newTextValue);
        return editor.getValue();
    }

    private Object convertToTypedArray(Object input, @Nullable String propertyName, Class<?> componentType) {
        if (input instanceof Collection) {
            Collection coll = (Collection)input;
            Object result = Array.newInstance(componentType, coll.size());
            int i = 0;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, it.next(), componentType);
                Array.set(result, i, value);
                ++i;
            }
            return result;
        }
        if (input.getClass().isArray()) {
            if (componentType.equals(input.getClass().componentType()) && !this.propertyEditorRegistry.hasCustomEditorForElement(componentType, propertyName)) {
                return input;
            }
            int arrayLength = Array.getLength(input);
            Object result = Array.newInstance(componentType, arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, Array.get(input, i), componentType);
                Array.set(result, i, value);
            }
            return result;
        }
        Object result = Array.newInstance(componentType, 1);
        Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, 0), null, input, componentType);
        Array.set(result, 0, value);
        return result;
    }

    private Collection<?> convertToTypedCollection(Collection<?> original, @Nullable String propertyName, Class<?> requiredType, @Nullable TypeDescriptor typeDescriptor) {
        Collection convertedCopy;
        Iterator<?> it;
        TypeDescriptor elementType;
        if (!Collection.class.isAssignableFrom(requiredType)) {
            return original;
        }
        boolean approximable = CollectionFactory.isApproximableCollectionType(requiredType);
        if (!approximable && !this.canCreateCopy(requiredType)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Custom Collection type [" + original.getClass().getName() + "] does not allow for creating a copy - injecting original Collection as-is"));
            }
            return original;
        }
        boolean originalAllowed = requiredType.isInstance(original);
        TypeDescriptor typeDescriptor2 = elementType = typeDescriptor != null ? typeDescriptor.getElementTypeDescriptor() : null;
        if (elementType == null && originalAllowed && !this.propertyEditorRegistry.hasCustomEditorForElement(null, propertyName)) {
            return original;
        }
        try {
            it = original.iterator();
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot access Collection of type [" + original.getClass().getName() + "] - injecting original Collection as-is: " + String.valueOf(ex)));
            }
            return original;
        }
        try {
            convertedCopy = approximable && requiredType.isInstance(original) ? CollectionFactory.createApproximateCollection(original, (int)original.size()) : CollectionFactory.createCollection(requiredType, (int)original.size());
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot create copy of Collection type [" + original.getClass().getName() + "] - injecting original Collection as-is: " + String.valueOf(ex)));
            }
            return original;
        }
        int i = 0;
        while (it.hasNext()) {
            Object element = it.next();
            String indexedPropertyName = this.buildIndexedPropertyName(propertyName, i);
            Object convertedElement = this.convertIfNecessary(indexedPropertyName, null, element, elementType != null ? elementType.getType() : null, elementType);
            try {
                convertedCopy.add(convertedElement);
            }
            catch (Throwable ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Collection type [" + original.getClass().getName() + "] seems to be read-only - injecting original Collection as-is: " + String.valueOf(ex)));
                }
                return original;
            }
            originalAllowed = originalAllowed && element == convertedElement;
            ++i;
        }
        return originalAllowed ? original : convertedCopy;
    }

    private Map<?, ?> convertToTypedMap(Map<?, ?> original, @Nullable String propertyName, Class<?> requiredType, @Nullable TypeDescriptor typeDescriptor) {
        Map convertedCopy;
        Iterator<Map.Entry<?, ?>> it;
        TypeDescriptor valueType;
        if (!Map.class.isAssignableFrom(requiredType)) {
            return original;
        }
        boolean approximable = CollectionFactory.isApproximableMapType(requiredType);
        if (!approximable && !this.canCreateCopy(requiredType)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Custom Map type [" + original.getClass().getName() + "] does not allow for creating a copy - injecting original Map as-is"));
            }
            return original;
        }
        boolean originalAllowed = requiredType.isInstance(original);
        TypeDescriptor keyType = typeDescriptor != null ? typeDescriptor.getMapKeyTypeDescriptor() : null;
        TypeDescriptor typeDescriptor2 = valueType = typeDescriptor != null ? typeDescriptor.getMapValueTypeDescriptor() : null;
        if (keyType == null && valueType == null && originalAllowed && !this.propertyEditorRegistry.hasCustomEditorForElement(null, propertyName)) {
            return original;
        }
        try {
            it = original.entrySet().iterator();
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot access Map of type [" + original.getClass().getName() + "] - injecting original Map as-is: " + String.valueOf(ex)));
            }
            return original;
        }
        try {
            convertedCopy = approximable && requiredType.isInstance(original) ? CollectionFactory.createApproximateMap(original, (int)original.size()) : CollectionFactory.createMap(requiredType, (int)original.size());
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot create copy of Map type [" + original.getClass().getName() + "] - injecting original Map as-is: " + String.valueOf(ex)));
            }
            return original;
        }
        while (it.hasNext()) {
            Map.Entry<?, ?> entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            String keyedPropertyName = this.buildKeyedPropertyName(propertyName, key);
            Object convertedKey = this.convertIfNecessary(keyedPropertyName, null, key, keyType != null ? keyType.getType() : null, keyType);
            Object convertedValue = this.convertIfNecessary(keyedPropertyName, null, value, valueType != null ? valueType.getType() : null, valueType);
            try {
                convertedCopy.put(convertedKey, convertedValue);
            }
            catch (Throwable ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Map type [" + original.getClass().getName() + "] seems to be read-only - injecting original Map as-is: " + String.valueOf(ex)));
                }
                return original;
            }
            originalAllowed = originalAllowed && key == convertedKey && value == convertedValue;
        }
        return originalAllowed ? original : convertedCopy;
    }

    private @Nullable String buildIndexedPropertyName(@Nullable String propertyName, int index) {
        return propertyName != null ? propertyName + "[" + index + "]" : null;
    }

    private @Nullable String buildKeyedPropertyName(@Nullable String propertyName, Object key) {
        return propertyName != null ? propertyName + "[" + String.valueOf(key) + "]" : null;
    }

    private boolean canCreateCopy(Class<?> requiredType) {
        return !requiredType.isInterface() && !Modifier.isAbstract(requiredType.getModifiers()) && Modifier.isPublic(requiredType.getModifiers()) && ClassUtils.hasConstructor(requiredType, (Class[])new Class[0]);
    }
}

