/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public abstract class AbstractFactoryBean
implements FactoryBean,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean singleton = true;
    private ConfigurableBeanFactory beanFactory;
    private boolean initialized = false;
    private Object singletonInstance;
    private Object earlySingletonInstance;

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        }
    }

    protected TypeConverter getBeanTypeConverter() {
        if (this.beanFactory != null) {
            return this.beanFactory.getTypeConverter();
        }
        return new SimpleTypeConverter();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isSingleton()) {
            this.initialized = true;
            this.singletonInstance = this.createInstance();
            this.earlySingletonInstance = null;
        }
    }

    public final Object getObject() throws Exception {
        if (this.isSingleton()) {
            return this.initialized ? this.singletonInstance : this.getEarlySingletonInstance();
        }
        return this.createInstance();
    }

    private Object getEarlySingletonInstance() throws Exception {
        Class[] ifcs = this.getEarlySingletonInterfaces();
        if (ifcs == null) {
            throw new FactoryBeanNotInitializedException(this.getClass().getName() + " does not support circular references");
        }
        if (this.earlySingletonInstance == null) {
            this.earlySingletonInstance = Proxy.newProxyInstance(this.getClass().getClassLoader(), ifcs, new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    try {
                        return method.invoke(AbstractFactoryBean.this.getSingletonInstance(), args);
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getTargetException();
                    }
                }
            });
        }
        return this.earlySingletonInstance;
    }

    private Object getSingletonInstance() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("Singleton instance not initialized yet");
        }
        return this.singletonInstance;
    }

    public void destroy() throws Exception {
        if (this.isSingleton()) {
            this.destroyInstance(this.singletonInstance);
        }
    }

    public abstract Class getObjectType();

    protected abstract Object createInstance() throws Exception;

    protected Class[] getEarlySingletonInterfaces() {
        Class[] classArray;
        Class type = this.getObjectType();
        if (type != null && type.isInterface()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = type;
        } else {
            classArray = null;
        }
        return classArray;
    }

    protected void destroyInstance(Object instance) throws Exception {
    }
}

