/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.BeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultBeanDefinitionDocumentReader
implements BeanDefinitionDocumentReader {
    public static final String BEAN_ELEMENT = "bean";
    public static final String ALIAS_ELEMENT = "alias";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ALIAS_ATTRIBUTE = "alias";
    public static final String IMPORT_ELEMENT = "import";
    public static final String RESOURCE_ATTRIBUTE = "resource";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private XmlReaderContext readerContext;

    public void registerBeanDefinitions(Document doc, XmlReaderContext readerContext) {
        this.readerContext = readerContext;
        this.logger.debug((Object)"Loading bean definitions");
        Element root = doc.getDocumentElement();
        BeanDefinitionParserDelegate delegate = this.createHelper(readerContext, root);
        this.preProcessXml(root);
        this.parseBeanDefinitions(root, delegate);
        this.postProcessXml(root);
    }

    protected BeanDefinitionParserDelegate createHelper(XmlReaderContext readerContext, Element root) {
        BeanDefinitionParserDelegate delegate = new BeanDefinitionParserDelegate(readerContext);
        delegate.initDefaults(root);
        return delegate;
    }

    protected final XmlReaderContext getReaderContext() {
        return this.readerContext;
    }

    protected Object extractSource(Element ele) {
        return this.readerContext.extractSource(ele);
    }

    protected void parseBeanDefinitions(Element root, BeanDefinitionParserDelegate delegate) {
        if (delegate.isDefaultNamespace(root.getNamespaceURI())) {
            NodeList nl = root.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!(node instanceof Element)) continue;
                Element ele = (Element)node;
                String namespaceUri = ele.getNamespaceURI();
                if (delegate.isDefaultNamespace(namespaceUri)) {
                    this.parseDefaultElement(ele, delegate);
                    continue;
                }
                delegate.parseCustomElement(ele);
            }
        } else {
            delegate.parseCustomElement(root);
        }
    }

    private void parseDefaultElement(Element ele, BeanDefinitionParserDelegate delegate) {
        if (DomUtils.nodeNameEquals((Node)ele, (String)IMPORT_ELEMENT)) {
            this.importBeanDefinitionResource(ele);
        } else if (DomUtils.nodeNameEquals((Node)ele, (String)"alias")) {
            this.processAliasRegistration(ele);
        } else if (DomUtils.nodeNameEquals((Node)ele, (String)BEAN_ELEMENT)) {
            this.processBeanDefinition(ele, delegate);
        }
    }

    protected void importBeanDefinitionResource(Element ele) {
        String location = ele.getAttribute(RESOURCE_ATTRIBUTE);
        if (!StringUtils.hasText((String)location)) {
            this.getReaderContext().error("Resource location must not be empty", ele);
            return;
        }
        if (ResourcePatternUtils.isUrl((String)(location = SystemPropertyUtils.resolvePlaceholders((String)location)))) {
            int importCount = this.getReaderContext().getReader().loadBeanDefinitions(location);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Imported " + importCount + " bean definitions from URL location [" + location + "]"));
            }
        } else {
            try {
                Resource relativeResource = this.getReaderContext().getResource().createRelative(location);
                int importCount = this.getReaderContext().getReader().loadBeanDefinitions(relativeResource);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Imported " + importCount + " bean definitions from relative location [" + location + "]"));
                }
            }
            catch (IOException ex) {
                this.getReaderContext().error("Invalid relative resource location [" + location + "] to import bean definitions from", ele, null, ex);
            }
        }
        this.getReaderContext().fireImportProcessed(location, this.extractSource(ele));
    }

    protected void processAliasRegistration(Element ele) {
        String name = ele.getAttribute(NAME_ATTRIBUTE);
        String alias = ele.getAttribute("alias");
        boolean valid = true;
        if (!StringUtils.hasText((String)name)) {
            this.getReaderContext().error("Name must not be empty", ele);
            valid = false;
        }
        if (!StringUtils.hasText((String)alias)) {
            this.getReaderContext().error("Alias must not be empty", ele);
            valid = false;
        }
        if (valid) {
            try {
                this.getReaderContext().getRegistry().registerAlias(name, alias);
            }
            catch (BeanDefinitionStoreException ex) {
                this.getReaderContext().error(ex.getMessage(), ele);
            }
            this.getReaderContext().fireAliasRegistered(name, alias, this.extractSource(ele));
        }
    }

    protected void processBeanDefinition(Element ele, BeanDefinitionParserDelegate delegate) {
        BeanDefinitionHolder bdHolder = delegate.parseBeanDefinitionElement(ele);
        if (bdHolder != null) {
            bdHolder = delegate.decorateBeanDefinitionIfRequired(ele, bdHolder);
            BeanDefinitionReaderUtils.registerBeanDefinition(bdHolder, this.getReaderContext().getRegistry());
            this.getReaderContext().fireComponentRegistered(new BeanComponentDefinition(bdHolder));
        }
    }

    protected void preProcessXml(Element root) {
    }

    protected void postProcessXml(Element root) {
    }
}

