/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class NamespaceHandlerSupport
implements NamespaceHandler {
    private final Map parsers = new HashMap();
    private final Map decorators = new HashMap();
    private final Map attributeDecorators = new HashMap();

    public final BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
        return this.findDecoratorForNode(node).decorate(node, definition, parserContext);
    }

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        return this.findParserForElement(element).parse(element, parserContext);
    }

    protected final BeanDefinitionParser findParserForElement(Element element) {
        BeanDefinitionParser parser = (BeanDefinitionParser)this.parsers.get(element.getLocalName());
        if (parser == null) {
            throw new IllegalArgumentException("Cannot locate BeanDefinitionParser for element [" + element.getLocalName() + "].");
        }
        return parser;
    }

    protected final BeanDefinitionDecorator findDecoratorForNode(Node node) {
        BeanDefinitionDecorator decorator = null;
        if (node instanceof Element) {
            decorator = (BeanDefinitionDecorator)this.decorators.get(node.getLocalName());
        } else if (node instanceof Attr) {
            decorator = (BeanDefinitionDecorator)this.attributeDecorators.get(node.getLocalName());
        } else {
            throw new IllegalArgumentException("Cannot decorate based on Nodes of type [" + node.getClass().getName() + "]");
        }
        if (decorator == null) {
            throw new IllegalArgumentException("Cannot locate BeanDefinitionDecorator for " + (node instanceof Element ? "element" : "attribute") + " [" + node.getLocalName() + "]");
        }
        return decorator;
    }

    protected final void registerBeanDefinitionParser(String elementName, BeanDefinitionParser parser) {
        this.parsers.put(elementName, parser);
    }

    protected final void registerBeanDefinitionDecorator(String elementName, BeanDefinitionDecorator decorator) {
        this.decorators.put(elementName, decorator);
    }

    protected final void registerBeanDefinitionDecoratorForAttribute(String attributeName, BeanDefinitionDecorator decorator) {
        this.attributeDecorators.put(attributeName, decorator);
    }
}

