/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class StringArrayPropertyEditor
extends PropertyEditorSupport {
    public static final String DEFAULT_SEPARATOR = ",";
    private final String separator;

    public StringArrayPropertyEditor() {
        this.separator = DEFAULT_SEPARATOR;
    }

    public StringArrayPropertyEditor(String separator) {
        this.separator = separator;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        String[] array = StringUtils.delimitedListToStringArray((String)text, (String)this.separator);
        this.setValue(array);
    }

    public String getAsText() {
        Object[] array = (String[])this.getValue();
        return StringUtils.arrayToDelimitedString((Object[])array, (String)this.separator);
    }
}

