/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.core.GenericsHelper;
import org.springframework.core.JdkVersion;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PropertyTypeConverter {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$PropertyTypeConverter == null ? (class$org$springframework$beans$PropertyTypeConverter = PropertyTypeConverter.class$("org.springframework.beans.PropertyTypeConverter")) : class$org$springframework$beans$PropertyTypeConverter));
    private final PropertyEditorRegistrySupport propertyEditorRegistry;
    private final Object targetObject;
    static /* synthetic */ Class class$org$springframework$beans$PropertyTypeConverter;

    public PropertyTypeConverter(PropertyEditorRegistrySupport propertyEditorRegistry) {
        this(propertyEditorRegistry, null);
    }

    public PropertyTypeConverter(PropertyEditorRegistrySupport propertyEditorRegistry, Object targetObject) {
        Assert.notNull((Object)propertyEditorRegistry, (String)"Property editor registry must not be null");
        this.propertyEditorRegistry = propertyEditorRegistry;
        this.targetObject = targetObject;
    }

    public Object convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class requiredType) throws IllegalArgumentException {
        return this.convertIfNecessary(propertyName, oldValue, newValue, requiredType, null, null);
    }

    public Object convertIfNecessary(Object oldValue, Object newValue, PropertyDescriptor descriptor) throws IllegalArgumentException {
        Assert.notNull((Object)descriptor, (String)"PropertyDescriptor must not be null");
        return this.convertIfNecessary(descriptor.getName(), oldValue, newValue, descriptor.getPropertyType(), descriptor, new MethodParameter(descriptor.getWriteMethod(), 0));
    }

    public Object convertIfNecessary(Object newValue, Class requiredType, MethodParameter methodParam) throws IllegalArgumentException {
        return this.convertIfNecessary(null, null, newValue, requiredType, null, methodParam);
    }

    protected Object convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class requiredType, PropertyDescriptor descriptor, MethodParameter methodParam) throws IllegalArgumentException {
        Object convertedValue = newValue;
        PropertyEditor pe = this.propertyEditorRegistry.findCustomEditor(requiredType, propertyName);
        if (pe != null || requiredType != null && !requiredType.isInstance(convertedValue)) {
            if (pe == null && descriptor != null) {
                if (JdkVersion.getMajorJavaVersion() >= 2) {
                    pe = descriptor.createPropertyEditor(this.targetObject);
                } else {
                    Class<?> editorClass = descriptor.getPropertyEditorClass();
                    if (editorClass != null) {
                        pe = (PropertyEditor)BeanUtils.instantiateClass(editorClass);
                    }
                }
            }
            if (pe == null && requiredType != null && (pe = this.propertyEditorRegistry.getDefaultEditor(requiredType)) == null) {
                pe = PropertyEditorManager.findEditor(requiredType);
            }
            convertedValue = this.convertValue(convertedValue, requiredType, pe, oldValue);
        }
        if (requiredType != null) {
            if (requiredType.isArray()) {
                return this.convertToTypedArray(convertedValue, propertyName, requiredType.getComponentType());
            }
            if (methodParam != null) {
                if (convertedValue instanceof Collection) {
                    convertedValue = this.convertToTypedCollection((Collection)convertedValue, propertyName, methodParam);
                } else if (convertedValue instanceof Map) {
                    convertedValue = this.convertToTypedMap((Map)convertedValue, propertyName, methodParam);
                }
            }
            if (convertedValue != null && !requiredType.isPrimitive() && !requiredType.isInstance(convertedValue)) {
                block16: {
                    if (convertedValue instanceof String) {
                        try {
                            Field enumField = requiredType.getField((String)convertedValue);
                            return enumField.get(null);
                        }
                        catch (Exception ex) {
                            if (!logger.isDebugEnabled()) break block16;
                            logger.debug((Object)("Field [" + convertedValue + "] isn't an enum value"), (Throwable)ex);
                        }
                    }
                }
                throw new IllegalArgumentException("No matching editors or conversion strategy found");
            }
        }
        return convertedValue;
    }

    protected Object convertValue(Object newValue, Class requiredType, PropertyEditor pe, Object oldValue) {
        Object convertedValue = newValue;
        if (pe != null && !(convertedValue instanceof String)) {
            pe.setValue(convertedValue);
            Object newConvertedValue = pe.getValue();
            if (newConvertedValue != convertedValue) {
                convertedValue = newConvertedValue;
                pe = null;
            }
        }
        if (requiredType != null && !requiredType.isArray() && convertedValue instanceof String[]) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converting String array to comma-delimited String [" + convertedValue + "]"));
            }
            convertedValue = StringUtils.arrayToCommaDelimitedString((Object[])((String[])convertedValue));
        }
        if (pe != null && convertedValue instanceof String) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converting String to [" + requiredType + "] using property editor [" + pe + "]"));
            }
            pe.setValue(oldValue);
            pe.setAsText((String)convertedValue);
            convertedValue = pe.getValue();
        }
        return convertedValue;
    }

    protected Object convertToTypedArray(Object input, String propertyName, Class componentType) {
        if (input instanceof Collection) {
            Collection coll = (Collection)input;
            Object result = Array.newInstance(componentType, coll.size());
            int i = 0;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, it.next(), componentType);
                Array.set(result, i, value);
                ++i;
            }
            return result;
        }
        if (input != null && input.getClass().isArray()) {
            int arrayLength = Array.getLength(input);
            Object result = Array.newInstance(componentType, arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, Array.get(input, i), componentType);
                Array.set(result, i, value);
            }
            return result;
        }
        Object result = Array.newInstance(componentType, 1);
        Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, 0), null, input, componentType);
        Array.set(result, 0, value);
        return result;
    }

    protected Collection convertToTypedCollection(Collection original, String propertyName, MethodParameter methodParam) {
        Class elementType = null;
        if (JdkVersion.getMajorJavaVersion() >= 2) {
            elementType = GenericsHelper.getCollectionParameterType((MethodParameter)methodParam);
        }
        if (elementType != null) {
            Collection convertedCopy = (Collection)BeanUtils.instantiateClass(original.getClass());
            int i = 0;
            Iterator it = original.iterator();
            while (it.hasNext()) {
                Object convertedElement = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, it.next(), elementType);
                convertedCopy.add(convertedElement);
                ++i;
            }
            return convertedCopy;
        }
        return original;
    }

    protected Map convertToTypedMap(Map original, String propertyName, MethodParameter methodParam) {
        Class mapKeyType = null;
        Class mapValueType = null;
        if (JdkVersion.getMajorJavaVersion() >= 2) {
            mapKeyType = GenericsHelper.getMapKeyParameterType((MethodParameter)methodParam);
            mapValueType = GenericsHelper.getMapValueParameterType((MethodParameter)methodParam);
        }
        if (mapKeyType != null || mapValueType != null) {
            Map convertedCopy = (Map)BeanUtils.instantiateClass(original.getClass());
            Iterator it = original.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                Object convertedMapKey = this.convertIfNecessary(this.buildKeyedPropertyName(propertyName, key), null, entry.getKey(), mapKeyType);
                Object convertedMapValue = this.convertIfNecessary(this.buildKeyedPropertyName(propertyName, key), null, entry.getValue(), mapValueType);
                convertedCopy.put(convertedMapKey, convertedMapValue);
            }
            return convertedCopy;
        }
        return original;
    }

    private String buildIndexedPropertyName(String propertyName, int index) {
        return propertyName != null ? propertyName + "[" + index + "]" : null;
    }

    private String buildKeyedPropertyName(String propertyName, Object key) {
        return propertyName != null ? propertyName + "[" + key + "]" : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

