/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessExceptionsException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanWrapperImpl
extends PropertyEditorRegistrySupport
implements BeanWrapper {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$BeanWrapperImpl == null ? (class$org$springframework$beans$BeanWrapperImpl = BeanWrapperImpl.class$("org.springframework.beans.BeanWrapperImpl")) : class$org$springframework$beans$BeanWrapperImpl));
    private Object object;
    private String nestedPath = "";
    private Object rootObject;
    private boolean extractOldValueForEditor = false;
    private CachedIntrospectionResults cachedIntrospectionResults;
    private Map nestedBeanWrappers;
    static /* synthetic */ Class class$org$springframework$beans$BeanWrapperImpl;

    public BeanWrapperImpl() {
        this(true);
    }

    public BeanWrapperImpl(boolean registerDefaultEditors) {
        if (registerDefaultEditors) {
            this.registerDefaultEditors();
        }
    }

    public BeanWrapperImpl(Object object) {
        this();
        this.setWrappedInstance(object);
    }

    public BeanWrapperImpl(Class clazz) {
        this();
        this.setWrappedInstance(BeanUtils.instantiateClass(clazz));
    }

    public BeanWrapperImpl(Object object, String nestedPath, Object rootObject) {
        this();
        this.setWrappedInstance(object, nestedPath, rootObject);
    }

    private BeanWrapperImpl(Object object, String nestedPath, BeanWrapper superBw) {
        this.setWrappedInstance(object, nestedPath, superBw.getWrappedInstance());
        this.setExtractOldValueForEditor(superBw.isExtractOldValueForEditor());
    }

    public void setWrappedInstance(Object object) {
        this.setWrappedInstance(object, "", null);
    }

    public void setWrappedInstance(Object object, String nestedPath, Object rootObject) {
        Assert.notNull((Object)object, (String)"Bean object must not be null");
        this.object = object;
        this.nestedPath = nestedPath != null ? nestedPath : "";
        this.rootObject = !"".equals(this.nestedPath) ? rootObject : object;
        this.nestedBeanWrappers = null;
        this.setIntrospectionClass(object.getClass());
    }

    public Object getWrappedInstance() {
        return this.object;
    }

    public Class getWrappedClass() {
        return this.object != null ? this.object.getClass() : null;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public Object getRootInstance() {
        return this.rootObject;
    }

    public Class getRootClass() {
        return this.rootObject != null ? this.rootObject.getClass() : null;
    }

    protected void setIntrospectionClass(Class clazz) {
        if (this.cachedIntrospectionResults == null || !this.cachedIntrospectionResults.getBeanClass().equals(clazz)) {
            this.cachedIntrospectionResults = CachedIntrospectionResults.forClass(clazz);
        }
    }

    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
        this.extractOldValueForEditor = extractOldValueForEditor;
    }

    public boolean isExtractOldValueForEditor() {
        return this.extractOldValueForEditor;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        Assert.state((this.cachedIntrospectionResults != null ? 1 : 0) != 0, (String)"BeanWrapper does not hold a bean instance");
        return this.cachedIntrospectionResults.getBeanInfo().getPropertyDescriptors();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws BeansException {
        PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
        if (pd == null) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "No property '" + propertyName + "' found");
        }
        return pd;
    }

    protected PropertyDescriptor getPropertyDescriptorInternal(String propertyName) throws BeansException {
        Assert.state((this.cachedIntrospectionResults != null ? 1 : 0) != 0, (String)"BeanWrapper does not hold a bean instance");
        Assert.notNull((Object)propertyName, (String)"Property name must not be null");
        BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        return nestedBw.cachedIntrospectionResults.getPropertyDescriptor(this.getFinalPath(nestedBw, propertyName));
    }

    public Class getPropertyType(String propertyName) throws BeansException {
        try {
            PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
            if (pd != null) {
                return pd.getPropertyType();
            }
            Object value = this.getPropertyValue(propertyName);
            if (value != null) {
                return value.getClass();
            }
            Class editorType = this.guessPropertyTypeFromEditors(propertyName);
            if (editorType != null) {
                return editorType;
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    public boolean isReadableProperty(String propertyName) {
        block4: {
            try {
                PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
                if (pd != null) {
                    if (pd.getReadMethod() != null) {
                        return true;
                    }
                    break block4;
                }
                this.getPropertyValue(propertyName);
                return true;
            }
            catch (InvalidPropertyException invalidPropertyException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isWritableProperty(String propertyName) {
        block4: {
            try {
                PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
                if (pd != null) {
                    if (pd.getWriteMethod() != null) {
                        return true;
                    }
                    break block4;
                }
                this.getPropertyValue(propertyName);
                return true;
            }
            catch (InvalidPropertyException invalidPropertyException) {
                // empty catch block
            }
        }
        return false;
    }

    private String getFinalPath(BeanWrapper bw, String nestedPath) {
        if (bw == this) {
            return nestedPath;
        }
        return nestedPath.substring(PropertyAccessorUtils.getLastNestedPropertySeparatorIndex(nestedPath) + 1);
    }

    protected BeanWrapperImpl getBeanWrapperForPropertyPath(String propertyPath) {
        int pos = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex(propertyPath);
        if (pos > -1) {
            String nestedProperty = propertyPath.substring(0, pos);
            String nestedPath = propertyPath.substring(pos + 1);
            BeanWrapperImpl nestedBw = this.getNestedBeanWrapper(nestedProperty);
            return nestedBw.getBeanWrapperForPropertyPath(nestedPath);
        }
        return this;
    }

    private BeanWrapperImpl getNestedBeanWrapper(String nestedProperty) {
        if (this.nestedBeanWrappers == null) {
            this.nestedBeanWrappers = new HashMap();
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(nestedProperty);
        String canonicalName = tokens.canonicalName;
        Object propertyValue = this.getPropertyValue(tokens);
        if (propertyValue == null) {
            throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + canonicalName);
        }
        BeanWrapperImpl nestedBw = (BeanWrapperImpl)this.nestedBeanWrappers.get(canonicalName);
        if (nestedBw == null || nestedBw.getWrappedInstance() != propertyValue) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating new nested BeanWrapper for property '" + canonicalName + "'"));
            }
            nestedBw = this.newNestedBeanWrapper(propertyValue, this.nestedPath + canonicalName + ".");
            this.copyDefaultEditorsTo(nestedBw);
            this.copyCustomEditorsTo(nestedBw, canonicalName);
            this.nestedBeanWrappers.put(canonicalName, nestedBw);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using cached nested BeanWrapper for property '" + canonicalName + "'"));
        }
        return nestedBw;
    }

    protected BeanWrapperImpl newNestedBeanWrapper(Object object, String nestedPath) {
        return new BeanWrapperImpl(object, nestedPath, this);
    }

    private PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        String actualName = null;
        ArrayList<String> keys = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = propertyName.indexOf("]", keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key = propertyName.substring(keyStart + "[".length(), keyEnd)).startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            keys.add(key);
            searchIndex = keyEnd + "]".length();
        }
        tokens.canonicalName = tokens.actualName = actualName != null ? actualName : propertyName;
        if (!keys.isEmpty()) {
            tokens.canonicalName = tokens.canonicalName + "[" + StringUtils.collectionToDelimitedString(keys, (String)"][") + "]";
            tokens.keys = StringUtils.toStringArray(keys);
        }
        return tokens;
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedBw, propertyName));
        return nestedBw.getPropertyValue(tokens);
    }

    private Object getPropertyValue(PropertyTokenHolder tokens) throws BeansException {
        String propertyName = tokens.canonicalName;
        String actualName = tokens.actualName;
        PropertyDescriptor pd = this.getPropertyDescriptorInternal(tokens.actualName);
        if (pd == null || pd.getReadMethod() == null) {
            throw new NotReadablePropertyException(this.getRootClass(), this.nestedPath + propertyName);
        }
        Method readMethod = pd.getReadMethod();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("About to invoke read method [" + readMethod + "] on object of class [" + this.object.getClass().getName() + "]"));
        }
        try {
            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                readMethod.setAccessible(true);
            }
            Object value = readMethod.invoke(this.object, (Object[])null);
            if (tokens.keys != null) {
                block5: for (int i = 0; i < tokens.keys.length; ++i) {
                    String key = tokens.keys[i];
                    if (value == null) {
                        throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value of property referenced in indexed property path '" + propertyName + "': returned null");
                    }
                    if (value.getClass().isArray()) {
                        value = Array.get(value, Integer.parseInt(key));
                        continue;
                    }
                    if (value instanceof List) {
                        List list = (List)value;
                        value = list.get(Integer.parseInt(key));
                        continue;
                    }
                    if (value instanceof Set) {
                        Set set = (Set)value;
                        int index = Integer.parseInt(key);
                        if (index < 0 || index >= set.size()) {
                            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot get element with index " + index + " from Set of size " + set.size() + ", accessed using property path '" + propertyName + "'");
                        }
                        Iterator it = set.iterator();
                        int j = 0;
                        while (it.hasNext()) {
                            Object elem = it.next();
                            if (j == index) {
                                value = elem;
                                continue block5;
                            }
                            ++j;
                        }
                        continue;
                    }
                    if (value instanceof Map) {
                        Map map = (Map)value;
                        value = map.get(key);
                        continue;
                    }
                    throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Set nor a Map; returned value was [" + value + "]");
                }
            }
            return value;
        }
        catch (InvocationTargetException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Getter for property '" + actualName + "' threw exception", ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Illegal attempt to get property '" + actualName + "' threw exception", ex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Index of out of bounds in property path '" + propertyName + "'", ex);
        }
        catch (NumberFormatException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid index in property path '" + propertyName + "'", ex);
        }
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        BeanWrapperImpl nestedBw = null;
        try {
            nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        }
        catch (NotReadablePropertyException ex) {
            throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Nested property in path '" + propertyName + "' does not exist", (Throwable)((Object)ex));
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedBw, propertyName));
        nestedBw.setPropertyValue(tokens, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setPropertyValue(PropertyTokenHolder tokens, Object newValue) throws BeansException {
        Object oldValue;
        Method writeMethod;
        PropertyDescriptor pd;
        String propertyName;
        block31: {
            propertyName = tokens.canonicalName;
            if (tokens.keys != null) {
                PropertyTokenHolder getterTokens = new PropertyTokenHolder();
                getterTokens.canonicalName = tokens.canonicalName;
                getterTokens.actualName = tokens.actualName;
                getterTokens.keys = new String[tokens.keys.length - 1];
                System.arraycopy(tokens.keys, 0, getterTokens.keys, 0, tokens.keys.length - 1);
                Object propValue = null;
                try {
                    propValue = this.getPropertyValue(getterTokens);
                }
                catch (NotReadablePropertyException ex) {
                    throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "'", (Throwable)((Object)ex));
                }
                String key = tokens.keys[tokens.keys.length - 1];
                if (propValue == null) {
                    throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "': returned null");
                }
                if (propValue.getClass().isArray()) {
                    Class<?> requiredType = propValue.getClass().getComponentType();
                    int arrayIndex = Integer.parseInt(key);
                    Object oldValue2 = null;
                    try {
                        if (this.isExtractOldValueForEditor()) {
                            oldValue2 = Array.get(propValue, arrayIndex);
                        }
                        Object convertedValue = this.doTypeConversionIfNecessary(propertyName, propertyName, oldValue2, newValue, requiredType);
                        Array.set(propValue, Integer.parseInt(key), convertedValue);
                        return;
                    }
                    catch (IllegalArgumentException ex) {
                        PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue2, newValue);
                        throw new TypeMismatchException(pce, requiredType, (Throwable)ex);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid array index in property path '" + propertyName + "'", ex);
                    }
                } else if (propValue instanceof List) {
                    List list = (List)propValue;
                    int index = Integer.parseInt(key);
                    Object oldValue3 = null;
                    if (this.isExtractOldValueForEditor() && index < list.size()) {
                        oldValue3 = list.get(index);
                    }
                    Object convertedValue = this.doTypeConversionIfNecessary(propertyName, propertyName, oldValue3, newValue, null);
                    if (index < list.size()) {
                        list.set(index, convertedValue);
                        return;
                    } else {
                        if (index < list.size()) return;
                        for (int i = list.size(); i < index; ++i) {
                            try {
                                list.add(null);
                                continue;
                            }
                            catch (NullPointerException ex) {
                                throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot set element with index " + index + " in List of size " + list.size() + ", accessed using property path '" + propertyName + "': List does not support filling up gaps with null elements");
                            }
                        }
                        list.add(convertedValue);
                    }
                    return;
                } else {
                    if (!(propValue instanceof Map)) throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Map; returned value was [" + newValue + "]");
                    Map map = (Map)propValue;
                    Object oldValue4 = null;
                    if (this.isExtractOldValueForEditor()) {
                        oldValue4 = map.get(key);
                    }
                    Object convertedValue = this.doTypeConversionIfNecessary(propertyName, propertyName, oldValue4, newValue, null);
                    map.put(key, convertedValue);
                }
                return;
            }
            pd = this.getPropertyDescriptorInternal(propertyName);
            if (pd == null || pd.getWriteMethod() == null) {
                throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName);
            }
            Method readMethod = pd.getReadMethod();
            writeMethod = pd.getWriteMethod();
            oldValue = null;
            if (this.isExtractOldValueForEditor() && readMethod != null) {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                try {
                    oldValue = readMethod.invoke(this.object, new Object[0]);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block31;
                    logger.debug((Object)("Could not read previous value of property '" + this.nestedPath + propertyName + "'"), (Throwable)ex);
                }
            }
        }
        try {
            Object convertedValue = this.doTypeConversionIfNecessary(propertyName, propertyName, oldValue, newValue, pd.getPropertyType());
            if (pd.getPropertyType().isPrimitive() && (convertedValue == null || "".equals(convertedValue))) {
                throw new IllegalArgumentException("Invalid value [" + newValue + "] for property '" + pd.getName() + "' of primitive type [" + pd.getPropertyType() + "]");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("About to invoke write method [" + writeMethod + "] on object of class [" + this.object.getClass().getName() + "]"));
            }
            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                writeMethod.setAccessible(true);
            }
            writeMethod.invoke(this.object, convertedValue);
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("Invoked write method [" + writeMethod + "] with value of type [" + pd.getPropertyType().getName() + "]"));
            return;
        }
        catch (InvocationTargetException ex) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            if (!(ex.getTargetException() instanceof ClassCastException)) throw new MethodInvocationException(propertyChangeEvent, ex.getTargetException());
            throw new TypeMismatchException(propertyChangeEvent, pd.getPropertyType(), ex.getTargetException());
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, pd.getPropertyType(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new MethodInvocationException(pce, (Throwable)ex);
        }
    }

    public void setPropertyValue(PropertyValue pv) throws BeansException {
        this.setPropertyValue(pv.getName(), pv.getValue());
    }

    public void setPropertyValues(Map map) throws BeansException {
        this.setPropertyValues(new MutablePropertyValues(map));
    }

    public void setPropertyValues(PropertyValues pvs) throws BeansException {
        this.setPropertyValues(pvs, false);
    }

    public void setPropertyValues(PropertyValues propertyValues, boolean ignoreUnknown) throws BeansException {
        ArrayList<PropertyAccessException> propertyAccessExceptions = new ArrayList<PropertyAccessException>();
        PropertyValue[] pvs = propertyValues.getPropertyValues();
        for (int i = 0; i < pvs.length; ++i) {
            try {
                this.setPropertyValue(pvs[i]);
                continue;
            }
            catch (NotWritablePropertyException ex) {
                if (ignoreUnknown) continue;
                throw ex;
            }
            catch (PropertyAccessException ex) {
                propertyAccessExceptions.add(ex);
            }
        }
        if (!propertyAccessExceptions.isEmpty()) {
            PropertyAccessException[] paeArray = propertyAccessExceptions.toArray(new PropertyAccessException[propertyAccessExceptions.size()]);
            throw new PropertyAccessExceptionsException(this, paeArray);
        }
    }

    private PropertyChangeEvent createPropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        return new PropertyChangeEvent(this.rootObject != null ? this.rootObject : "constructor", propertyName != null ? this.nestedPath + propertyName : null, oldValue, newValue);
    }

    public Object doTypeConversionIfNecessary(Object newValue, Class requiredType) throws TypeMismatchException {
        return this.doTypeConversionIfNecessary(null, null, null, newValue, requiredType);
    }

    protected Object doTypeConversionIfNecessary(String propertyName, String fullPropertyName, Object oldValue, Object newValue, Class requiredType) throws TypeMismatchException {
        Object convertedValue = newValue;
        PropertyEditor pe = this.findCustomEditor(requiredType, fullPropertyName);
        if (pe != null || requiredType != null && (requiredType.isArray() || !requiredType.isInstance(convertedValue))) {
            if (requiredType != null && pe == null && (pe = this.getDefaultEditor(requiredType)) == null) {
                pe = PropertyEditorManager.findEditor(requiredType);
            }
            if (pe != null && !(convertedValue instanceof String)) {
                try {
                    pe.setValue(convertedValue);
                    Object newConvertedValue = pe.getValue();
                    if (newConvertedValue != convertedValue) {
                        convertedValue = newConvertedValue;
                        pe = null;
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType, (Throwable)ex);
                }
            }
            if (requiredType != null && !requiredType.isArray() && convertedValue instanceof String[]) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converting String array to comma-delimited String [" + convertedValue + "]"));
                }
                convertedValue = StringUtils.arrayToCommaDelimitedString((Object[])((String[])convertedValue));
            }
            if (pe != null && convertedValue instanceof String) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converting String to [" + requiredType + "] using property editor [" + pe + "]"));
                }
                try {
                    pe.setValue(oldValue);
                    pe.setAsText((String)convertedValue);
                    convertedValue = pe.getValue();
                }
                catch (IllegalArgumentException ex) {
                    throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType, (Throwable)ex);
                }
            }
            if (requiredType != null) {
                if (requiredType.isArray()) {
                    Class<?> componentType = requiredType.getComponentType();
                    if (convertedValue instanceof Collection) {
                        Collection coll = (Collection)convertedValue;
                        Object result = Array.newInstance(componentType, coll.size());
                        int i = 0;
                        Iterator it = coll.iterator();
                        while (it.hasNext()) {
                            Object value = this.doTypeConversionIfNecessary(propertyName, propertyName + "[" + i + "]", null, it.next(), componentType);
                            Array.set(result, i, value);
                            ++i;
                        }
                        return result;
                    }
                    if (convertedValue != null && convertedValue.getClass().isArray()) {
                        int arrayLength = Array.getLength(convertedValue);
                        Object result = Array.newInstance(componentType, arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            Object value = this.doTypeConversionIfNecessary(propertyName, propertyName + "[" + i + "]", null, Array.get(convertedValue, i), componentType);
                            Array.set(result, i, value);
                        }
                        return result;
                    }
                    if (convertedValue != null) {
                        Object result = Array.newInstance(componentType, 1);
                        Object value = this.doTypeConversionIfNecessary(propertyName, propertyName + "[" + 0 + "]", null, convertedValue, componentType);
                        Array.set(result, 0, value);
                        return result;
                    }
                }
                if (convertedValue != null && !requiredType.isPrimitive() && !requiredType.isInstance(convertedValue)) {
                    block23: {
                        if (convertedValue instanceof String) {
                            try {
                                Field enumField = requiredType.getField((String)convertedValue);
                                return enumField.get(null);
                            }
                            catch (Exception ex) {
                                if (!logger.isDebugEnabled()) break block23;
                                logger.debug((Object)("Field [" + convertedValue + "] isn't an enum value"), (Throwable)ex);
                            }
                        }
                    }
                    throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType);
                }
            }
        }
        return convertedValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        if (this.object != null) {
            sb.append(": wrapping object of type [").append(this.object.getClass().getName()).append("]");
        } else {
            sb.append(": no wrapped object set");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PropertyTokenHolder {
        public String canonicalName;
        public String actualName;
        public String[] keys;

        private PropertyTokenHolder() {
        }
    }
}

