/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.scope;

import org.springframework.aop.scope.ScopedObject;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.util.Assert;

public class DefaultScopedObject
implements ScopedObject {
    private final ConfigurableBeanFactory beanFactory;
    private final String targetBeanName;

    public DefaultScopedObject(ConfigurableBeanFactory beanFactory, String targetBeanName) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        Assert.notNull((Object)targetBeanName, (String)"Target bean name must not be null");
        this.beanFactory = beanFactory;
        this.targetBeanName = targetBeanName;
    }

    public void remove() {
        this.beanFactory.destroyScopedBean(this.targetBeanName);
    }
}

