/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.InstantiationModelAwarePointcutAdvisor;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.PrototypeAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.ReflectiveAspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.SingletonMetadataAwareAspectInstanceFactory;
import org.springframework.aop.aspectj.autoproxy.AspectJInvocationContextExposingAdvisorAutoProxyCreator;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAwareAspectJAutoProxyCreator
extends AspectJInvocationContextExposingAdvisorAutoProxyCreator {
    private static final long serialVersionUID = -3347584141231774337L;
    private static final Log staticLogger = LogFactory.getLog(AnnotationAwareAspectJAutoProxyCreator.class);
    private static final String ORDER_PROPERTY = "order";
    private AspectJAdvisorFactory aspectJAdvisorFactory = new ReflectiveAspectJAdvisorFactory();
    private List<Pattern> includePatterns;

    @Override
    protected boolean isInfrastructureClass(Class beanClass, String beanName) {
        if (this.aspectJAdvisorFactory.isAspect(beanClass)) {
            return true;
        }
        return super.isInfrastructureClass(beanClass, beanName);
    }

    public void setAspectJAdvisorFactory(AspectJAdvisorFactory aspectJAdvisorFactory) {
        Assert.notNull((Object)this.aspectJAdvisorFactory, (String)"AspectJAdvisorFactory must not be null");
        this.aspectJAdvisorFactory = aspectJAdvisorFactory;
    }

    public void setIncludePatterns(List<String> patterns) {
        this.includePatterns = new ArrayList<Pattern>(patterns.size());
        for (String patternText : patterns) {
            this.includePatterns.add(Pattern.compile(patternText));
        }
    }

    private boolean isIncluded(String beanName) {
        if (this.includePatterns == null) {
            return true;
        }
        for (Pattern pattern : this.includePatterns) {
            if (!pattern.matcher(beanName).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List findCandidateAdvisors() {
        LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        advisors.addAll(super.findCandidateAdvisors());
        advisors.addAll(this.createAspectJAdvisors(this.aspectJAdvisorFactory, this.getBeanFactory()));
        return advisors;
    }

    public List<Advisor> createAspectJAdvisors(AspectJAdvisorFactory aspectJAdvisorFactory, BeanFactory beanFactory) throws BeansException, IllegalStateException {
        String[] beanDefinitionNames;
        LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        for (String beanName : beanDefinitionNames = BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)beanFactory))) {
            Class beanType;
            if (!this.isIncluded(beanName) || (beanType = beanFactory.getType(beanName)) == null || !aspectJAdvisorFactory.isAspect(beanType)) continue;
            AspectMetadata amd = new AspectMetadata(beanType, beanName);
            if (amd.getAjType().getPerClause().getKind() == PerClauseKind.SINGLETON) {
                Object beanInstance = beanFactory.getBean(beanName);
                List<Advisor> classAdvisors = aspectJAdvisorFactory.getAdvisors(new SingletonMetadataAwareAspectInstanceFactory(beanInstance, beanName));
                this.setAdvisorOrderIfNecessary(classAdvisors, beanInstance);
                staticLogger.debug((Object)("Found " + classAdvisors.size() + " AspectJ advice methods"));
                advisors.addAll(classAdvisors);
                continue;
            }
            if (beanFactory.isSingleton(beanName)) {
                throw new IllegalArgumentException("Bean with name '" + beanName + "' is a singleton, but aspect instantiation model is not singleton");
            }
            List<Advisor> classAdvisors = aspectJAdvisorFactory.getAdvisors(new PrototypeAspectInstanceFactory(beanFactory, beanName));
            this.setAdvisorOrderIfNecessary(classAdvisors, beanFactory, beanName);
            staticLogger.debug((Object)("Found " + classAdvisors.size() + " AspectJ advice methods in bean with name '" + beanName + "'"));
            advisors.addAll(classAdvisors);
        }
        return advisors;
    }

    private void setAdvisorOrderIfNecessary(List<Advisor> advisors, Object beanInstance) {
        if (beanInstance instanceof Ordered) {
            int order = ((Ordered)beanInstance).getOrder();
            for (Advisor advisor : advisors) {
                if (!(advisor instanceof InstantiationModelAwarePointcutAdvisor)) continue;
                ((InstantiationModelAwarePointcutAdvisor)advisor).setOrder(order);
            }
        }
    }

    private void setAdvisorOrderIfNecessary(List<Advisor> advisors, BeanFactory beanFactory, String beanName) {
        BeanDefinition beanDef;
        MutablePropertyValues mpvs;
        if (beanFactory instanceof ConfigurableListableBeanFactory && (mpvs = (beanDef = ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(beanName)).getPropertyValues()).contains(ORDER_PROPERTY)) {
            int order = Integer.parseInt((String)mpvs.getPropertyValue(ORDER_PROPERTY).getValue());
            for (Advisor advisor : advisors) {
                if (!(advisor instanceof InstantiationModelAwarePointcutAdvisor)) continue;
                ((InstantiationModelAwarePointcutAdvisor)advisor).setOrder(order);
            }
        }
    }
}

