/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.Resource;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.core.JLineShell;
import org.springframework.shell.core.Parser;
import org.springframework.shell.core.SimpleExecutionStrategy;
import org.springframework.shell.core.SimpleParser;
import org.springframework.shell.plugin.BannerProvider;
import org.springframework.shell.plugin.HistoryFileNameProvider;
import org.springframework.shell.plugin.PluginProvider;
import org.springframework.shell.plugin.PromptProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLineShellComponent
extends JLineShell
implements Lifecycle {
    private volatile boolean running = false;
    private Thread shellThread;
    private ApplicationContext applicationContext;
    private boolean printBanner = true;
    private static AnnotationAwareOrderComparator annotationOrderComparator = new AnnotationAwareOrderComparator();
    private String historyFileName;
    private String promptText;
    private String productName;
    private String banner;
    private String version;
    private String welcomeMessage;
    private ExecutionStrategy executionStrategy = new SimpleExecutionStrategy();
    private SimpleParser parser = new SimpleParser();

    public SimpleParser getSimpleParser() {
        return this.parser;
    }

    public void start() {
        this.customizePlugin();
        this.shellThread = new Thread((Runnable)this, "Spring Shell");
        this.shellThread.start();
        this.running = true;
    }

    public void stop() {
        this.closeShell();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void waitForComplete() {
        try {
            this.shellThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Collection<URL> findResources(String path) {
        try {
            Resource[] resources = this.applicationContext.getResources(path);
            ArrayList<URL> list = new ArrayList<URL>(resources.length);
            for (Resource resource : resources) {
                list.add(resource.getURL());
            }
            return list;
        }
        catch (IOException ex) {
            this.logger.fine("Cannot find path " + path);
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    @Override
    protected Parser getParser() {
        return this.parser;
    }

    @Override
    public String getStartupNotifications() {
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void customizePlugin() {
        this.historyFileName = this.getHistoryFileName();
        this.promptText = this.getPromptText();
        String[] banner = this.getBannerText();
        this.banner = banner[0];
        this.welcomeMessage = banner[1];
        this.version = banner[2];
        this.productName = banner[3];
    }

    @Override
    protected String getHistoryFileName() {
        String providerHistoryFileName = this.getHighestPriorityProvider(HistoryFileNameProvider.class).getHistoryFileName();
        if (providerHistoryFileName != null) {
            return providerHistoryFileName;
        }
        return this.historyFileName;
    }

    @Override
    protected String getPromptText() {
        String providerPromptText = this.getHighestPriorityProvider(PromptProvider.class).getPrompt();
        if (providerPromptText != null) {
            return providerPromptText;
        }
        return this.promptText;
    }

    private String[] getBannerText() {
        String[] bannerText = new String[4];
        BannerProvider provider = this.getHighestPriorityProvider(BannerProvider.class);
        bannerText[0] = provider.getBanner();
        bannerText[1] = provider.getWelcomeMessage();
        bannerText[2] = provider.getVersion();
        bannerText[3] = provider.name();
        return bannerText;
    }

    private <T extends PluginProvider> T getHighestPriorityProvider(Class<T> t) {
        Map providers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, t);
        ArrayList sortedProviders = new ArrayList(providers.values());
        Collections.sort(sortedProviders, annotationOrderComparator);
        PluginProvider highestPriorityProvider = (PluginProvider)sortedProviders.get(0);
        return (T)highestPriorityProvider;
    }

    @Override
    public void printBannerAndWelcome() {
        if (this.printBanner) {
            this.logger.info(this.banner);
            this.logger.info(this.getWelcomeMessage());
        }
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public void setPrintBanner(boolean printBanner) {
        this.printBanner = printBanner;
    }

    @Override
    protected String getProductName() {
        return this.productName;
    }

    @Override
    protected String getVersion() {
        return this.version;
    }
}

