/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal.model;

import org.springframework.shell.test.jediterm.terminal.TextStyle;
import org.springframework.shell.test.jediterm.terminal.model.TerminalLine;

public abstract class TerminalLineIntervalHighlighting {
    private final TerminalLine myLine;
    private final int myStartOffset;
    private final int myEndOffset;
    private boolean myDisposed = false;

    TerminalLineIntervalHighlighting(TerminalLine line, int startOffset, int length) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("Negative startOffset: " + startOffset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Negative length: " + length);
        }
        this.myLine = line;
        this.myStartOffset = startOffset;
        this.myEndOffset = startOffset + length;
    }

    public TerminalLine getLine() {
        return this.myLine;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public int getLength() {
        return this.myEndOffset - this.myStartOffset;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public final void dispose() {
        this.doDispose();
        this.myDisposed = true;
    }

    protected abstract void doDispose();

    public boolean intersectsWith(int otherStartOffset, int otherEndOffset) {
        return this.myEndOffset > otherStartOffset && otherEndOffset > this.myStartOffset;
    }

    public TextStyle mergeWith(TextStyle style) {
        return new TextStyle();
    }

    public String toString() {
        return "startOffset=" + this.myStartOffset + ", endOffset=" + this.myEndOffset + ", disposed=" + this.myDisposed;
    }
}

