/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal.model;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.shell.test.jediterm.terminal.CursorShape;
import org.springframework.shell.test.jediterm.terminal.RequestOrigin;
import org.springframework.shell.test.jediterm.terminal.Terminal;
import org.springframework.shell.test.jediterm.terminal.TerminalDisplay;
import org.springframework.shell.test.jediterm.terminal.TerminalMode;
import org.springframework.shell.test.jediterm.terminal.TerminalOutputStream;
import org.springframework.shell.test.jediterm.terminal.TextStyle;
import org.springframework.shell.test.jediterm.terminal.emulator.charset.CharacterSet;
import org.springframework.shell.test.jediterm.terminal.emulator.charset.GraphicSet;
import org.springframework.shell.test.jediterm.terminal.emulator.charset.GraphicSetState;
import org.springframework.shell.test.jediterm.terminal.model.CharBuffer;
import org.springframework.shell.test.jediterm.terminal.model.StoredCursor;
import org.springframework.shell.test.jediterm.terminal.model.StyleState;
import org.springframework.shell.test.jediterm.terminal.model.Tabulator;
import org.springframework.shell.test.jediterm.terminal.model.TerminalTextBuffer;
import org.springframework.shell.test.jediterm.terminal.ui.TerminalCoordinates;
import org.springframework.shell.test.jediterm.terminal.util.CharUtils;

public class JediTerminal
implements Terminal,
TerminalCoordinates {
    private static final Log log = LogFactory.getLog((String)JediTerminal.class.getName());
    private int myScrollRegionTop;
    private int myScrollRegionBottom;
    private volatile int myCursorX = 0;
    private volatile int myCursorY = 1;
    private int myTerminalWidth;
    private int myTerminalHeight;
    private final TerminalDisplay myDisplay;
    private final TerminalTextBuffer myTerminalTextBuffer;
    private final StyleState myStyleState;
    private StoredCursor myStoredCursor = null;
    private final EnumSet<TerminalMode> myModes = EnumSet.noneOf(TerminalMode.class);
    private final Stack<String> myWindowTitlesStack = new Stack();
    private final Tabulator myTabulator;
    private final GraphicSetState myGraphicSetState;
    private TerminalOutputStream myTerminalOutput = null;
    private boolean myCursorYChanged;

    public JediTerminal(TerminalDisplay display, TerminalTextBuffer buf, StyleState initialStyleState) {
        this.myDisplay = display;
        this.myTerminalTextBuffer = buf;
        this.myStyleState = initialStyleState;
        this.myTerminalWidth = display.getColumnCount();
        this.myTerminalHeight = display.getRowCount();
        this.myScrollRegionTop = 1;
        this.myScrollRegionBottom = this.myTerminalHeight;
        this.myTabulator = new DefaultTabulator(this.myTerminalWidth);
        this.myGraphicSetState = new GraphicSetState();
        this.reset();
    }

    @Override
    public void setModeEnabled(TerminalMode mode, boolean enabled) {
        if (enabled) {
            this.myModes.add(mode);
        } else {
            this.myModes.remove((Object)mode);
        }
        mode.setEnabled(this, enabled);
    }

    @Override
    public void disconnected() {
    }

    private void wrapLines() {
        if (this.myCursorX >= this.myTerminalWidth) {
            this.myCursorX = 0;
            this.myTerminalTextBuffer.getLine(this.myCursorY - 1).deleteCharacters(this.myTerminalWidth);
            if (this.isAutoWrap()) {
                this.myTerminalTextBuffer.getLine(this.myCursorY - 1).setWrapped(true);
                ++this.myCursorY;
            }
        }
    }

    private void finishText() {
        this.scrollY();
    }

    @Override
    public void writeCharacters(String string) {
        this.writeDecodedCharacters(this.decodeUsingGraphicalState(string));
    }

    private void writeDecodedCharacters(char[] string) {
        this.myTerminalTextBuffer.lock();
        try {
            if (this.myCursorYChanged && string.length > 0) {
                this.myCursorYChanged = false;
                if (this.myCursorY > 1) {
                    this.myTerminalTextBuffer.getLine(this.myCursorY - 2).setWrapped(false);
                }
            }
            this.wrapLines();
            this.scrollY();
            if (string.length != 0) {
                CharBuffer characters = this.newCharBuf(string);
                this.myTerminalTextBuffer.writeString(this.myCursorX, this.myCursorY, characters);
                this.myCursorX += characters.length();
            }
            this.finishText();
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    @Override
    public void writeDoubleByte(char[] bytesOfChar) throws UnsupportedEncodingException {
        this.writeCharacters(new String(bytesOfChar, 0, 2));
    }

    private char[] decodeUsingGraphicalState(String string) {
        StringBuilder result = new StringBuilder();
        for (char c : string.toCharArray()) {
            result.append(this.myGraphicSetState.map(c));
        }
        return result.toString().toCharArray();
    }

    @Override
    public void writeUnwrappedString(String string) {
        int amountInLine;
        int length = string.length();
        for (int off = 0; off < length; off += amountInLine) {
            amountInLine = Math.min(this.distanceToLineEnd(), length - off);
            this.writeCharacters(string.substring(off, off + amountInLine));
            this.wrapLines();
            this.scrollY();
        }
    }

    public void scrollY() {
        this.myTerminalTextBuffer.lock();
        try {
            if (this.myCursorY > this.myScrollRegionBottom) {
                int dy = this.myScrollRegionBottom - this.myCursorY;
                this.myCursorY = this.myScrollRegionBottom;
                this.scrollArea(this.myScrollRegionTop, this.scrollingRegionSize(), dy);
            }
            if (this.myCursorY < this.myScrollRegionTop) {
                this.myCursorY = this.myScrollRegionTop;
            }
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    public void crnl() {
        this.carriageReturn();
        this.newLine();
    }

    @Override
    public void newLine() {
        this.myCursorYChanged = true;
        ++this.myCursorY;
        this.scrollY();
    }

    @Override
    public void mapCharsetToGL(int num) {
        this.myGraphicSetState.setGL(num);
    }

    @Override
    public void mapCharsetToGR(int num) {
        this.myGraphicSetState.setGR(num);
    }

    @Override
    public void designateCharacterSet(int tableNumber, char charset) {
        GraphicSet gs = this.myGraphicSetState.getGraphicSet(tableNumber);
        this.myGraphicSetState.designateGraphicSet(gs, charset);
    }

    @Override
    public void singleShiftSelect(int num) {
        this.myGraphicSetState.overrideGL(num);
    }

    @Override
    public void setAnsiConformanceLevel(int level) {
        if (level == 1 || level == 2) {
            this.myGraphicSetState.designateGraphicSet(0, CharacterSet.ASCII);
            this.myGraphicSetState.designateGraphicSet(1, CharacterSet.DEC_SUPPLEMENTAL);
            this.mapCharsetToGL(0);
            this.mapCharsetToGR(1);
        } else if (level == 3) {
            this.designateCharacterSet(0, 'B');
            this.mapCharsetToGL(0);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setWindowTitle(String name) {
        this.myDisplay.setWindowTitle(name);
    }

    @Override
    public void saveWindowTitleOnStack() {
        String title = this.myDisplay.getWindowTitle();
        this.myWindowTitlesStack.push(title);
    }

    @Override
    public void restoreWindowTitleFromStack() {
        if (!this.myWindowTitlesStack.empty()) {
            String title = this.myWindowTitlesStack.pop();
            this.myDisplay.setWindowTitle(title);
        }
    }

    @Override
    public void backspace() {
        --this.myCursorX;
        if (this.myCursorX < 0) {
            --this.myCursorY;
            this.myCursorX = this.myTerminalWidth - 1;
        }
        this.adjustXY(-1);
    }

    @Override
    public void carriageReturn() {
        this.myCursorX = 0;
    }

    @Override
    public void horizontalTab() {
        if (this.myCursorX >= this.myTerminalWidth) {
            return;
        }
        int length = this.myTerminalTextBuffer.getLine(this.myCursorY - 1).getText().length();
        int stop = this.myTabulator.nextTab(this.myCursorX);
        this.myCursorX = Math.max(this.myCursorX, length);
        if (this.myCursorX < stop) {
            char[] chars = new char[stop - this.myCursorX];
            Arrays.fill(chars, ' ');
            this.writeDecodedCharacters(chars);
        } else {
            this.myCursorX = stop;
        }
        this.adjustXY(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eraseInDisplay(int arg) {
        this.myTerminalTextBuffer.lock();
        try {
            int endY;
            int beginY;
            switch (arg) {
                case 0: {
                    if (this.myCursorX < this.myTerminalWidth) {
                        this.myTerminalTextBuffer.eraseCharacters(this.myCursorX, -1, this.myCursorY - 1);
                    }
                    beginY = this.myCursorY;
                    endY = this.myTerminalHeight - 1;
                    break;
                }
                case 1: {
                    this.myTerminalTextBuffer.eraseCharacters(0, this.myCursorX + 1, this.myCursorY - 1);
                    beginY = 0;
                    endY = this.myCursorY - 1;
                    break;
                }
                case 2: {
                    beginY = 0;
                    endY = this.myTerminalHeight - 1;
                    this.myTerminalTextBuffer.moveScreenLinesToHistory();
                    break;
                }
                default: {
                    log.warn((Object)("Unsupported erase in display mode:" + arg));
                    beginY = 1;
                    endY = 1;
                }
            }
            if (beginY != endY) {
                this.clearLines(beginY, endY);
            }
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    public void clearLines(int beginY, int endY) {
        this.myTerminalTextBuffer.lock();
        try {
            this.myTerminalTextBuffer.clearLines(beginY, endY);
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    @Override
    public void clearScreen() {
        this.clearLines(0, this.myTerminalHeight - 1);
    }

    @Override
    public void setCursorVisible(boolean visible) {
    }

    @Override
    public void useAlternateBuffer(boolean enabled) {
        this.myTerminalTextBuffer.useAlternateBuffer(enabled);
    }

    @Override
    public void setApplicationArrowKeys(boolean enabled) {
    }

    @Override
    public void setApplicationKeypad(boolean enabled) {
    }

    @Override
    public void setAutoNewLine(boolean enabled) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void eraseInLine(int arg) {
        this.myTerminalTextBuffer.lock();
        try {
            switch (arg) {
                case 0: {
                    if (this.myCursorX < this.myTerminalWidth) {
                        this.myTerminalTextBuffer.eraseCharacters(this.myCursorX, -1, this.myCursorY - 1);
                    }
                    this.myTerminalTextBuffer.getLine(this.myCursorY - 1).setWrapped(false);
                    return;
                }
                case 1: {
                    int extent = Math.min(this.myCursorX + 1, this.myTerminalWidth);
                    this.myTerminalTextBuffer.eraseCharacters(0, extent, this.myCursorY - 1);
                    return;
                }
                case 2: {
                    this.myTerminalTextBuffer.eraseCharacters(0, -1, this.myCursorY - 1);
                    return;
                }
                default: {
                    log.warn((Object)("Unsupported erase in line mode:" + arg));
                    return;
                }
            }
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    @Override
    public void deleteCharacters(int count) {
        this.myTerminalTextBuffer.lock();
        try {
            this.myTerminalTextBuffer.deleteCharacters(this.myCursorX, this.myCursorY - 1, count);
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    @Override
    public void insertBlankCharacters(int count) {
        this.myTerminalTextBuffer.lock();
        try {
            int extent = Math.min(count, this.myTerminalWidth - this.myCursorX);
            this.myTerminalTextBuffer.insertBlankCharacters(this.myCursorX, this.myCursorY - 1, extent);
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    @Override
    public void eraseCharacters(int count) {
        this.myTerminalTextBuffer.lock();
        try {
            this.myTerminalTextBuffer.eraseCharacters(this.myCursorX, this.myCursorX + count, this.myCursorY - 1);
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    @Override
    public void clearTabStopAtCursor() {
        this.myTabulator.clearTabStop(this.myCursorX);
    }

    @Override
    public void clearAllTabStops() {
        this.myTabulator.clearAllTabStops();
    }

    @Override
    public void setTabStopAtCursor() {
        this.myTabulator.setTabStop(this.myCursorX);
    }

    @Override
    public void insertLines(int count) {
        this.myTerminalTextBuffer.lock();
        try {
            this.myTerminalTextBuffer.insertLines(this.myCursorY - 1, count, this.myScrollRegionBottom);
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    @Override
    public void deleteLines(int count) {
        this.myTerminalTextBuffer.lock();
        try {
            this.myTerminalTextBuffer.deleteLines(this.myCursorY - 1, count, this.myScrollRegionBottom);
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    @Override
    public void setBlinkingCursor(boolean enabled) {
    }

    @Override
    public void cursorUp(int countY) {
        this.myTerminalTextBuffer.lock();
        try {
            this.myCursorYChanged = true;
            this.myCursorY -= countY;
            this.myCursorY = Math.max(this.myCursorY, this.scrollingRegionTop());
            this.adjustXY(-1);
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    @Override
    public void cursorDown(int dY) {
        this.myTerminalTextBuffer.lock();
        try {
            this.myCursorYChanged = true;
            this.myCursorY += dY;
            this.myCursorY = Math.min(this.myCursorY, this.scrollingRegionBottom());
            this.adjustXY(-1);
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    @Override
    public void index() {
        this.myTerminalTextBuffer.lock();
        try {
            if (this.myCursorY == this.myScrollRegionBottom) {
                this.scrollArea(this.myScrollRegionTop, this.scrollingRegionSize(), -1);
            } else {
                ++this.myCursorY;
                this.adjustXY(-1);
            }
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    private void scrollArea(int scrollRegionTop, int scrollRegionSize, int dy) {
        this.myDisplay.scrollArea(scrollRegionTop, scrollRegionSize, dy);
        this.myTerminalTextBuffer.scrollArea(scrollRegionTop, dy, scrollRegionTop + scrollRegionSize - 1);
    }

    @Override
    public void nextLine() {
        this.myTerminalTextBuffer.lock();
        try {
            this.myCursorX = 0;
            if (this.myCursorY == this.myScrollRegionBottom) {
                this.scrollArea(this.myScrollRegionTop, this.scrollingRegionSize(), -1);
            } else {
                ++this.myCursorY;
            }
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    private int scrollingRegionSize() {
        return this.myScrollRegionBottom - this.myScrollRegionTop + 1;
    }

    @Override
    public void reverseIndex() {
        this.myTerminalTextBuffer.lock();
        try {
            if (this.myCursorY == this.myScrollRegionTop) {
                this.scrollArea(this.myScrollRegionTop, this.scrollingRegionSize(), 1);
            } else {
                --this.myCursorY;
            }
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    private int scrollingRegionTop() {
        return this.isOriginMode() ? this.myScrollRegionTop : 1;
    }

    private int scrollingRegionBottom() {
        return this.isOriginMode() ? this.myScrollRegionBottom : this.myTerminalHeight;
    }

    @Override
    public void cursorForward(int dX) {
        this.myCursorX += dX;
        this.myCursorX = Math.min(this.myCursorX, this.myTerminalWidth - 1);
        this.adjustXY(1);
    }

    @Override
    public void cursorBackward(int dX) {
        this.myCursorX -= dX;
        this.myCursorX = Math.max(this.myCursorX, 0);
        this.adjustXY(-1);
    }

    @Override
    public void cursorShape(CursorShape shape) {
    }

    @Override
    public void cursorHorizontalAbsolute(int x) {
        this.cursorPosition(x, this.myCursorY);
    }

    @Override
    public void linePositionAbsolute(int y) {
        this.myCursorY = y;
        this.adjustXY(-1);
    }

    @Override
    public void cursorPosition(int x, int y) {
        this.myCursorY = this.isOriginMode() ? y + this.scrollingRegionTop() - 1 : y;
        if (this.myCursorY > this.scrollingRegionBottom()) {
            this.myCursorY = this.scrollingRegionBottom();
        }
        this.myCursorX = Math.max(0, x - 1);
        this.myCursorX = Math.min(this.myCursorX, this.myTerminalWidth - 1);
        this.myCursorY = Math.max(0, this.myCursorY);
        this.adjustXY(-1);
    }

    @Override
    public void setScrollingRegion(int top, int bottom) {
        if (top > bottom) {
            log.error((Object)("Top margin of scroll region can't be greater then bottom: " + top + ">" + bottom));
        }
        this.myScrollRegionTop = Math.max(1, top);
        this.myScrollRegionBottom = Math.min(this.myTerminalHeight, bottom);
        this.cursorPosition(1, 1);
    }

    @Override
    public void scrollUp(int count) {
        this.scrollDown(-count);
    }

    @Override
    public void scrollDown(int count) {
        this.myTerminalTextBuffer.lock();
        try {
            this.scrollArea(this.myScrollRegionTop, this.scrollingRegionSize(), count);
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    @Override
    public void resetScrollRegions() {
        this.setScrollingRegion(1, this.myTerminalHeight);
    }

    @Override
    public void characterAttributes(TextStyle textStyle) {
        this.myStyleState.setCurrent(textStyle);
    }

    @Override
    public void beep() {
        this.myDisplay.beep();
    }

    @Override
    public int distanceToLineEnd() {
        return this.myTerminalWidth - this.myCursorX;
    }

    @Override
    public void saveCursor() {
        this.myStoredCursor = this.createCursorState();
    }

    private StoredCursor createCursorState() {
        return new StoredCursor(this.myCursorX, this.myCursorY, this.myStyleState.getCurrent(), this.isAutoWrap(), this.isOriginMode(), this.myGraphicSetState);
    }

    @Override
    public void restoreCursor() {
        if (this.myStoredCursor != null) {
            this.restoreCursor(this.myStoredCursor);
        } else {
            this.setModeEnabled(TerminalMode.OriginMode, false);
            this.cursorPosition(1, 1);
            this.myStyleState.reset();
            this.myGraphicSetState.resetState();
        }
    }

    public void restoreCursor(StoredCursor storedCursor) {
        this.myCursorX = storedCursor.getCursorX();
        this.myCursorY = storedCursor.getCursorY();
        this.adjustXY(-1);
        this.myStyleState.setCurrent(storedCursor.getTextStyle());
        this.setModeEnabled(TerminalMode.AutoWrap, storedCursor.isAutoWrap());
        this.setModeEnabled(TerminalMode.OriginMode, storedCursor.isOriginMode());
        CharacterSet[] designations = storedCursor.getDesignations();
        for (int i = 0; i < designations.length; ++i) {
            this.myGraphicSetState.designateGraphicSet(i, designations[i]);
        }
        this.myGraphicSetState.setGL(storedCursor.getGLMapping());
        this.myGraphicSetState.setGR(storedCursor.getGRMapping());
        if (storedCursor.getGLOverride() >= 0) {
            this.myGraphicSetState.overrideGL(storedCursor.getGLOverride());
        }
    }

    @Override
    public void reset() {
        this.myGraphicSetState.resetState();
        this.myStyleState.reset();
        this.myTerminalTextBuffer.clearAll();
        this.initModes();
        this.cursorPosition(1, 1);
    }

    private void initModes() {
        this.myModes.clear();
        this.setModeEnabled(TerminalMode.AutoWrap, true);
        this.setModeEnabled(TerminalMode.CursorVisible, true);
        this.setModeEnabled(TerminalMode.CursorBlinking, true);
    }

    public boolean isOriginMode() {
        return this.myModes.contains((Object)TerminalMode.OriginMode);
    }

    public boolean isAutoWrap() {
        return this.myModes.contains((Object)TerminalMode.AutoWrap);
    }

    @Override
    public void setTerminalOutput(TerminalOutputStream terminalOutput) {
        this.myTerminalOutput = terminalOutput;
    }

    @Override
    public void setAltSendsEscape(boolean enabled) {
    }

    @Override
    public void deviceStatusReport(String str) {
        if (this.myTerminalOutput != null) {
            this.myTerminalOutput.sendString(str, false);
        }
    }

    @Override
    public void deviceAttributes(byte[] response) {
        if (this.myTerminalOutput != null) {
            this.myTerminalOutput.sendBytes(response, false);
        }
    }

    @Override
    public void setBracketedPasteMode(boolean enabled) {
        this.myDisplay.setBracketedPasteMode(enabled);
    }

    private void adjustXY(int dirX) {
        if (this.myCursorY > -this.myTerminalTextBuffer.getHistoryLinesCount() && Character.isLowSurrogate(this.myTerminalTextBuffer.getCharAt(this.myCursorX, this.myCursorY - 1))) {
            this.myCursorX = dirX > 0 ? (this.myCursorX == this.myTerminalWidth ? --this.myCursorX : ++this.myCursorX) : --this.myCursorX;
        }
    }

    @Override
    public int getX() {
        return this.myCursorX;
    }

    @Override
    public void setX(int x) {
        this.myCursorX = x;
        this.adjustXY(-1);
    }

    @Override
    public int getY() {
        return this.myCursorY;
    }

    @Override
    public void setY(int y) {
        this.myCursorY = y;
        this.adjustXY(-1);
    }

    public void writeString(String s) {
        this.writeCharacters(s);
    }

    @Override
    public void resize(int width, int height, RequestOrigin origin) {
        this.resize(width, height, origin, CompletableFuture.completedFuture(null));
    }

    @Override
    public void resize(int width, int height, RequestOrigin origin, CompletableFuture<?> promptUpdated) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillScreen(char c) {
        this.myTerminalTextBuffer.lock();
        try {
            char[] chars = new char[this.myTerminalWidth];
            Arrays.fill(chars, c);
            for (int row = 1; row <= this.myTerminalHeight; ++row) {
                this.myTerminalTextBuffer.writeString(0, row, this.newCharBuf(chars));
            }
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    private CharBuffer newCharBuf(char[] str) {
        char[] buf;
        int dwcCount = CharUtils.countDoubleWidthCharacters(str, 0, str.length, this.myDisplay.ambiguousCharsAreDoubleWidth());
        if (dwcCount > 0) {
            buf = new char[str.length + dwcCount];
            int j = 0;
            for (int i = 0; i < str.length; ++i) {
                buf[j] = str[i];
                int codePoint = Character.codePointAt(str, i);
                boolean doubleWidthCharacter = CharUtils.isDoubleWidthCharacter(codePoint, this.myDisplay.ambiguousCharsAreDoubleWidth());
                if (doubleWidthCharacter) {
                    buf[++j] = 57344;
                }
                ++j;
            }
        } else {
            buf = str;
        }
        return new CharBuffer(buf, 0, buf.length);
    }

    @Override
    public int getTerminalWidth() {
        return this.myTerminalWidth;
    }

    @Override
    public int getTerminalHeight() {
        return this.myTerminalHeight;
    }

    @Override
    public int getCursorX() {
        return this.myCursorX + 1;
    }

    @Override
    public int getCursorY() {
        return this.myCursorY;
    }

    @Override
    public StyleState getStyleState() {
        return this.myStyleState;
    }

    private static class DefaultTabulator
    implements Tabulator {
        private static final int TAB_LENGTH = 8;
        private final SortedSet<Integer> myTabStops = new TreeSet<Integer>();
        private int myWidth;
        private int myTabLength;

        public DefaultTabulator(int width) {
            this(width, 8);
        }

        public DefaultTabulator(int width, int tabLength) {
            this.myWidth = width;
            this.myTabLength = tabLength;
            this.initTabStops(width, tabLength);
        }

        private void initTabStops(int columns, int tabLength) {
            for (int i = tabLength; i < columns; i += tabLength) {
                this.myTabStops.add(i);
            }
        }

        @Override
        public void resize(int columns) {
            if (columns > this.myWidth) {
                for (int i = this.myTabLength * (this.myWidth / this.myTabLength); i < columns; i += this.myTabLength) {
                    if (i < this.myWidth) continue;
                    this.myTabStops.add(i);
                }
            } else {
                Iterator it = this.myTabStops.iterator();
                while (it.hasNext()) {
                    int i = (Integer)it.next();
                    if (i <= columns) continue;
                    it.remove();
                }
            }
            this.myWidth = columns;
        }

        @Override
        public void clearTabStop(int position) {
            this.myTabStops.remove(position);
        }

        @Override
        public void clearAllTabStops() {
            this.myTabStops.clear();
        }

        @Override
        public int getNextTabWidth(int position) {
            return this.nextTab(position) - position;
        }

        @Override
        public int getPreviousTabWidth(int position) {
            return position - this.previousTab(position);
        }

        @Override
        public int nextTab(int position) {
            int tabStop = Integer.MAX_VALUE;
            SortedSet<Integer> tailSet = this.myTabStops.tailSet(position + 1);
            if (!tailSet.isEmpty()) {
                tabStop = tailSet.first();
            }
            return Math.min(tabStop, this.myWidth - 1);
        }

        @Override
        public int previousTab(int position) {
            int tabStop = 0;
            SortedSet<Integer> headSet = this.myTabStops.headSet(position);
            if (!headSet.isEmpty()) {
                tabStop = headSet.last();
            }
            return Math.max(0, tabStop);
        }

        @Override
        public void setTabStop(int position) {
            this.myTabStops.add(position);
        }
    }

    public static interface ResizeHandler {
        public void sizeUpdated(int var1, int var2, int var3, int var4);
    }
}

