/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal;

import java.io.IOException;
import org.springframework.shell.test.jediterm.terminal.ArrayTerminalDataStream;
import org.springframework.shell.test.jediterm.terminal.TerminalDataStream;
import org.springframework.shell.test.jediterm.terminal.TtyConnector;
import org.springframework.shell.test.jediterm.terminal.util.CharUtils;

public class TtyBasedArrayDataStream
extends ArrayTerminalDataStream {
    private final TtyConnector ttyConnector;
    private final Runnable myOnBeforeBlockingWait;

    public TtyBasedArrayDataStream(TtyConnector ttyConnector, Runnable onBeforeBlockingWait) {
        super(new char[1024], 0, 0);
        this.ttyConnector = ttyConnector;
        this.myOnBeforeBlockingWait = onBeforeBlockingWait;
    }

    public TtyBasedArrayDataStream(TtyConnector ttyConnector) {
        super(new char[1024], 0, 0);
        this.ttyConnector = ttyConnector;
        this.myOnBeforeBlockingWait = null;
    }

    @Override
    public char getChar() throws IOException {
        if (this.length == 0) {
            this.fillBuf();
        }
        return super.getChar();
    }

    @Override
    public String readNonControlCharacters(int maxChars) throws IOException {
        if (this.length == 0) {
            this.fillBuf();
        }
        return super.readNonControlCharacters(maxChars);
    }

    public String toString() {
        return CharUtils.toHumanReadableText(new String(this.buf, this.offset, this.length));
    }

    private void fillBuf() throws IOException {
        this.offset = 0;
        if (!this.ttyConnector.ready() && this.myOnBeforeBlockingWait != null) {
            this.myOnBeforeBlockingWait.run();
        }
        this.length = this.ttyConnector.read(this.buf, this.offset, this.buf.length);
        if (this.length <= 0) {
            this.length = 0;
            throw new TerminalDataStream.EOF();
        }
    }
}

