/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.test.jediterm.terminal.StyledTextConsumer;
import org.springframework.shell.test.jediterm.terminal.StyledTextConsumerAdapter;
import org.springframework.shell.test.jediterm.terminal.TextStyle;
import org.springframework.shell.test.jediterm.terminal.model.CharBuffer;
import org.springframework.shell.test.jediterm.terminal.model.LinesBuffer;
import org.springframework.shell.test.jediterm.terminal.model.StyleState;
import org.springframework.shell.test.jediterm.terminal.model.TerminalLine;
import org.springframework.shell.test.jediterm.terminal.model.TerminalModelListener;
import org.springframework.shell.test.jediterm.terminal.util.Pair;

public class TerminalTextBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalTextBuffer.class);
    private final StyleState myStyleState;
    private LinesBuffer myHistoryBuffer;
    private LinesBuffer myScreenBuffer;
    private int myWidth;
    private int myHeight;
    private final int myHistoryLinesCount;
    private final Lock myLock = new ReentrantLock();
    private LinesBuffer myHistoryBufferBackup;
    private LinesBuffer myScreenBufferBackup;
    private boolean myUsingAlternateBuffer = false;
    private final List<TerminalModelListener> myListeners = new CopyOnWriteArrayList<TerminalModelListener>();
    private final List<TerminalModelListener> myTypeAheadListeners = new CopyOnWriteArrayList<TerminalModelListener>();

    public TerminalTextBuffer(int width, int height, StyleState styleState) {
        this(width, height, styleState, 5000);
    }

    public TerminalTextBuffer(int width, int height, StyleState styleState, int historyLinesCount) {
        this.myStyleState = styleState;
        this.myWidth = width;
        this.myHeight = height;
        this.myHistoryLinesCount = historyLinesCount;
        this.myScreenBuffer = this.createScreenBuffer();
        this.myHistoryBuffer = this.createHistoryBuffer();
    }

    private LinesBuffer createScreenBuffer() {
        return new LinesBuffer(-1);
    }

    private LinesBuffer createHistoryBuffer() {
        return new LinesBuffer(this.myHistoryLinesCount);
    }

    public void addModelListener(TerminalModelListener listener) {
        this.myListeners.add(listener);
    }

    public void addTypeAheadModelListener(TerminalModelListener listener) {
        this.myTypeAheadListeners.add(listener);
    }

    public void removeModelListener(TerminalModelListener listener) {
        this.myListeners.remove(listener);
    }

    public void removeTypeAheadModelListener(TerminalModelListener listener) {
        this.myTypeAheadListeners.remove(listener);
    }

    void fireModelChangeEvent() {
        for (TerminalModelListener modelListener : this.myListeners) {
            modelListener.modelChanged();
        }
    }

    void fireTypeAheadModelChangeEvent() {
        for (TerminalModelListener modelListener : this.myTypeAheadListeners) {
            modelListener.modelChanged();
        }
    }

    private TextStyle createEmptyStyleWithCurrentColor() {
        return this.myStyleState.getCurrent().createEmptyWithColors();
    }

    private TerminalLine.TextEntry createFillerEntry() {
        return new TerminalLine.TextEntry(this.createEmptyStyleWithCurrentColor(), new CharBuffer('\u0000', this.myWidth));
    }

    public void deleteCharacters(int x, int y, int count) {
        if (y > this.myHeight - 1 || y < 0) {
            LOG.error("attempt to delete in line " + y + "\nargs were x:" + x + " count:" + count);
        } else if (count < 0) {
            LOG.error("Attempt to delete negative chars number: count:" + count);
        } else if (count > 0) {
            this.myScreenBuffer.deleteCharacters(x, y, count, this.createEmptyStyleWithCurrentColor());
            this.fireModelChangeEvent();
        }
    }

    public void insertBlankCharacters(int x, int y, int count) {
        if (y > this.myHeight - 1 || y < 0) {
            LOG.error("attempt to insert blank chars in line " + y + "\nargs were x:" + x + " count:" + count);
        } else if (count < 0) {
            LOG.error("Attempt to insert negative blank chars number: count:" + count);
        } else if (count > 0) {
            this.myScreenBuffer.insertBlankCharacters(x, y, count, this.myWidth, this.createEmptyStyleWithCurrentColor());
            this.fireModelChangeEvent();
        }
    }

    public void writeString(int x, int y, CharBuffer str) {
        this.writeString(x, y, str, this.myStyleState.getCurrent());
    }

    public void addLine(TerminalLine line) {
        this.myScreenBuffer.addLines(List.of(line));
        this.fireModelChangeEvent();
    }

    private void writeString(int x, int y, CharBuffer str, TextStyle style) {
        this.myScreenBuffer.writeString(x, y - 1, str, style);
        this.fireModelChangeEvent();
    }

    public void scrollArea(int scrollRegionTop, int dy, int scrollRegionBottom) {
        if (dy == 0) {
            return;
        }
        if (dy > 0) {
            this.insertLines(scrollRegionTop - 1, dy, scrollRegionBottom);
        } else {
            LinesBuffer removed = this.deleteLines(scrollRegionTop - 1, -dy, scrollRegionBottom);
            if (scrollRegionTop == 1) {
                removed.moveTopLinesTo(removed.getLineCount(), this.myHistoryBuffer);
            }
            this.fireModelChangeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStyleLines() {
        final HashMap hashMap = new HashMap();
        this.myLock.lock();
        try {
            final StringBuilder sb = new StringBuilder();
            this.myScreenBuffer.processLines(0, this.myHeight, new StyledTextConsumerAdapter(){
                int count = 0;

                @Override
                public void consume(int x, int y, TextStyle style, CharBuffer characters, int startRow) {
                    int styleNum;
                    if (x == 0) {
                        sb.append("\n");
                    }
                    if (!hashMap.containsKey(styleNum = style.getId())) {
                        hashMap.put(styleNum, this.count++);
                    }
                    sb.append(String.format("%02d ", hashMap.get(styleNum)));
                }
            });
            String string = sb.toString();
            return string;
        }
        finally {
            this.myLock.unlock();
        }
    }

    public TerminalLine getLine(int index) {
        if (index >= 0) {
            if (index >= this.getHeight()) {
                LOG.error("Attempt to get line out of bounds: " + index + " >= " + this.getHeight());
                return TerminalLine.createEmpty();
            }
            return this.myScreenBuffer.getLine(index);
        }
        if (index < -this.getHistoryLinesCount()) {
            LOG.error("Attempt to get line out of bounds: " + index + " < " + -this.getHistoryLinesCount());
            return TerminalLine.createEmpty();
        }
        return this.myHistoryBuffer.getLine(this.getHistoryLinesCount() + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getScreen() {
        this.myLock.lock();
        ArrayList<String> lines = new ArrayList<String>();
        try {
            for (int row = 0; row < this.myHeight; ++row) {
                StringBuilder line = new StringBuilder(this.myScreenBuffer.getLine(row).getText());
                for (int i = line.length(); i < this.myWidth; ++i) {
                    line.append(' ');
                }
                if (line.length() > this.myWidth) {
                    line.setLength(this.myWidth);
                }
                lines.add(line.toString());
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        finally {
            this.myLock.unlock();
        }
    }

    public void processScreenLines(int yStart, int yCount, StyledTextConsumer consumer) {
        this.myScreenBuffer.processLines(yStart, yCount, consumer);
    }

    public void lock() {
        this.myLock.lock();
    }

    public void unlock() {
        this.myLock.unlock();
    }

    public boolean tryLock() {
        return this.myLock.tryLock();
    }

    public int getWidth() {
        return this.myWidth;
    }

    public int getHeight() {
        return this.myHeight;
    }

    public int getHistoryLinesCount() {
        return this.myHistoryBuffer.getLineCount();
    }

    public int getScreenLinesCount() {
        return this.myScreenBuffer.getLineCount();
    }

    public char getBuffersCharAt(int x, int y) {
        return this.getLine(y).charAt(x);
    }

    public TextStyle getStyleAt(int x, int y) {
        return this.getLine(y).getStyleAt(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Character, TextStyle> getStyledCharAt(int x, int y) {
        LinesBuffer linesBuffer = this.myScreenBuffer;
        synchronized (linesBuffer) {
            TerminalLine line = this.getLine(y);
            return new Pair<Character, TextStyle>(Character.valueOf(line.charAt(x)), line.getStyleAt(x));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getCharAt(int x, int y) {
        LinesBuffer linesBuffer = this.myScreenBuffer;
        synchronized (linesBuffer) {
            TerminalLine line = this.getLine(y);
            return line.charAt(x);
        }
    }

    public boolean isUsingAlternateBuffer() {
        return this.myUsingAlternateBuffer;
    }

    public void useAlternateBuffer(boolean enabled) {
        if (enabled) {
            if (!this.myUsingAlternateBuffer) {
                this.myScreenBufferBackup = this.myScreenBuffer;
                this.myHistoryBufferBackup = this.myHistoryBuffer;
                this.myScreenBuffer = this.createScreenBuffer();
                this.myHistoryBuffer = this.createHistoryBuffer();
                this.myUsingAlternateBuffer = true;
            }
        } else if (this.myUsingAlternateBuffer) {
            this.myScreenBuffer = this.myScreenBufferBackup;
            this.myHistoryBuffer = this.myHistoryBufferBackup;
            this.myScreenBufferBackup = this.createScreenBuffer();
            this.myHistoryBufferBackup = this.createHistoryBuffer();
            this.myUsingAlternateBuffer = false;
        }
        this.fireModelChangeEvent();
    }

    public LinesBuffer getHistoryBuffer() {
        return this.myHistoryBuffer;
    }

    public void insertLines(int y, int count, int scrollRegionBottom) {
        this.myScreenBuffer.insertLines(y, count, scrollRegionBottom - 1, this.createFillerEntry());
        this.fireModelChangeEvent();
    }

    public LinesBuffer deleteLines(int y, int count, int scrollRegionBottom) {
        LinesBuffer linesBuffer = this.myScreenBuffer.deleteLines(y, count, scrollRegionBottom - 1, this.createFillerEntry());
        this.fireModelChangeEvent();
        return linesBuffer;
    }

    public void clearLines(int startRow, int endRow) {
        this.myScreenBuffer.clearLines(startRow, endRow, this.createFillerEntry());
        this.fireModelChangeEvent();
    }

    public void eraseCharacters(int leftX, int rightX, int y) {
        TextStyle style = this.createEmptyStyleWithCurrentColor();
        if (y >= 0) {
            this.myScreenBuffer.clearArea(leftX, y, rightX, y + 1, style);
            this.fireModelChangeEvent();
        } else {
            LOG.error("Attempt to erase characters in line: " + y);
        }
    }

    public void clearAll() {
        this.myScreenBuffer.clearAll();
        this.fireModelChangeEvent();
    }

    public void processHistoryAndScreenLines(int scrollOrigin, int maximalLinesToProcess, StyledTextConsumer consumer) {
        if (maximalLinesToProcess < 0) {
            maximalLinesToProcess = this.myHistoryBuffer.getLineCount() + this.myScreenBuffer.getLineCount();
        }
        int linesFromHistory = Math.min(-scrollOrigin, maximalLinesToProcess);
        int y = this.myHistoryBuffer.getLineCount() + scrollOrigin;
        if (y < 0) {
            y = 0;
        }
        this.myHistoryBuffer.processLines(y, linesFromHistory, consumer, y);
        if (linesFromHistory < maximalLinesToProcess) {
            this.myScreenBuffer.processLines(0, maximalLinesToProcess - linesFromHistory, consumer, -linesFromHistory);
        }
    }

    public void clearHistory() {
        this.myHistoryBuffer.clearAll();
        this.fireModelChangeEvent();
    }

    void moveScreenLinesToHistory() {
        this.myLock.lock();
        try {
            this.myScreenBuffer.removeBottomEmptyLines(this.myScreenBuffer.getLineCount() - 1, this.myScreenBuffer.getLineCount());
            this.myScreenBuffer.moveTopLinesTo(this.myScreenBuffer.getLineCount(), this.myHistoryBuffer);
            if (this.myHistoryBuffer.getLineCount() > 0) {
                this.myHistoryBuffer.getLine(this.myHistoryBuffer.getLineCount() - 1).setWrapped(false);
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    LinesBuffer getHistoryBufferOrBackup() {
        return this.myUsingAlternateBuffer ? this.myHistoryBufferBackup : this.myHistoryBuffer;
    }

    LinesBuffer getScreenBufferOrBackup() {
        return this.myUsingAlternateBuffer ? this.myScreenBufferBackup : this.myScreenBuffer;
    }

    public int findScreenLineIndex(TerminalLine line) {
        return this.myScreenBuffer.findLineIndex(line);
    }

    public void clearTypeAheadPredictions() {
        this.myScreenBuffer.clearTypeAheadPredictions();
        this.myHistoryBuffer.clearTypeAheadPredictions();
        this.fireModelChangeEvent();
    }
}

