/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.legacy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.shell.Availability;
import org.springframework.shell.ConfigurableCommandRegistry;
import org.springframework.shell.MethodTarget;
import org.springframework.shell.MethodTargetRegistrar;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Component
public class LegacyMethodTargetRegistrar
implements MethodTargetRegistrar {
    @Autowired
    private ApplicationContext applicationContext;
    private Map<String, MethodTarget> commands = new TreeMap<String, MethodTarget>();

    public void register(ConfigurableCommandRegistry registry) {
        Map beans = this.applicationContext.getBeansOfType(CommandMarker.class);
        for (Object bean : beans.values()) {
            Class<?> clazz = bean.getClass();
            ReflectionUtils.doWithMethods(clazz, method -> {
                CliCommand cliCommand = method.getAnnotation(CliCommand.class);
                for (String key : cliCommand.value()) {
                    Supplier<Availability> availabilityIndicator = this.bridgeAvailabilityIndicator(key, bean);
                    MethodTarget target = new MethodTarget(method, bean, cliCommand.help(), availabilityIndicator);
                    registry.register(key, target);
                    this.commands.put(key, target);
                }
            }, method -> method.getAnnotation(CliCommand.class) != null);
        }
    }

    private Supplier<Availability> bridgeAvailabilityIndicator(String commandKey, Object bean) {
        Class<?> clazz = bean.getClass();
        HashSet candidates = new HashSet();
        ReflectionUtils.doWithMethods(clazz, candidates::add, method -> method.getAnnotation(CliAvailabilityIndicator.class) != null && Arrays.asList(method.getAnnotation(CliAvailabilityIndicator.class).value()).contains(commandKey));
        switch (candidates.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return () -> {
                    boolean available = (Boolean)ReflectionUtils.invokeMethod((Method)((Method)candidates.iterator().next()), (Object)bean);
                    return available ? Availability.available() : Availability.unavailable((String)"[Unknown reason]");
                };
            }
        }
        throw new IllegalStateException("Looks like there are several @" + CliAvailabilityIndicator.class.getSimpleName() + " for '" + commandKey + "'. Found " + candidates);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " contributing " + StringUtils.collectionToDelimitedString(this.commands.keySet(), (String)", ", (String)"[", (String)"]");
    }
}

