/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.table;

import java.util.ArrayList;
import org.springframework.shell.jline.tui.table.TextWrapper;

public class KeyValueTextWrapper
implements TextWrapper {
    private final String delimiter;

    public KeyValueTextWrapper() {
        this("=");
    }

    public KeyValueTextWrapper(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public String[] wrap(String[] original, int columnWidth) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : original) {
            line = line.trim();
            while (line.length() > columnWidth) {
                int cut = line.lastIndexOf(this.delimiter, columnWidth);
                if (cut == -1) {
                    cut = columnWidth;
                } else if (cut + this.delimiter.length() <= columnWidth) {
                    cut += this.delimiter.length();
                }
                result.add(this.rightPad(line.substring(0, cut), columnWidth));
                line = line.substring(cut).trim();
            }
            if (line.length() <= 0) continue;
            result.add(this.rightPad(line, columnWidth));
        }
        return result.toArray(new String[result.size()]);
    }

    private String rightPad(String raw, int width) {
        StringBuilder result = new StringBuilder(raw);
        for (int i = raw.length(); i < width; ++i) {
            result.append(' ');
        }
        return result.toString();
    }
}

