/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.style;

import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.style.PartsText;
import org.springframework.shell.jline.tui.style.ThemeResolver;
import org.springframework.util.Assert;
import org.stringtemplate.v4.AttributeRenderer;

public class PartsTextRenderer
implements AttributeRenderer<PartsText> {
    private final ThemeResolver themeResolver;

    public PartsTextRenderer(ThemeResolver themeResolver) {
        Assert.notNull((Object)themeResolver, (String)"themeResolver must be set");
        this.themeResolver = themeResolver;
    }

    public String toString(PartsText value, String formatString, Locale locale) {
        StringBuilder buf = new StringBuilder();
        Values values = PartsTextRenderer.mapValues(formatString);
        int len = 0;
        int dots = 2;
        int prefix = values.prefix;
        int width = values.width == null ? formatString.length() : values.width.intValue();
        int max = width - prefix;
        List<PartsText.PartText> parts = value.getParts();
        for (int i = 0; i < parts.size(); ++i) {
            int nextLen;
            PartsText.PartText current = parts.get(i);
            PartsText.PartText next = i + 1 < parts.size() ? parts.get(i + 1) : null;
            boolean doBreak = false;
            Object text = current.getText();
            int currentLen = len + ((String)text).length();
            int n = nextLen = next != null ? currentLen + next.getText().length() : -1;
            if (currentLen > max - dots && nextLen > 0) {
                int l = max - len;
                int diff = l - ((String)text).length();
                text = diff == 1 ? ((String)text).substring(0, ((String)text).length() - 1) + ".." : (diff == 0 ? String.format(locale, "%1." + (((String)text).length() - 2) + "s..", text) : String.format(locale, "%1." + (l - dots) + "s..", text));
                doBreak = true;
            } else if (currentLen == max - dots) {
                text = (String)text + "..";
                doBreak = true;
            } else if (currentLen > max) {
                int l = max - len - dots;
                text = l == 0 ? ".." : String.format(locale, "%1." + l + "s..", text);
                doBreak = true;
            }
            String tag = current.isMatch() ? values.matchStyle : values.textStyle;
            buf.append(String.format("@{%s %s}", this.themeResolver.resolveStyleTag(tag), text));
            len += ((String)text).length();
            if (doBreak) break;
        }
        return buf.toString();
    }

    private static Values mapValues(String expression) {
        Values values = new Values();
        Stream.of(expression.split(",")).map(String::trim).forEach(v -> {
            String[] split = v.split(":", 2);
            if (split.length == 2) {
                if ("width".equals(split[0])) {
                    values.setWidth(Integer.parseInt(split[1]));
                } else if ("prefix".equals(split[0])) {
                    values.setPrefix(Integer.parseInt(split[1]));
                } else if ("textStyle".equals(split[0])) {
                    values.setTextStyle(split[1]);
                } else if ("matchStyle".equals(split[0])) {
                    values.setMatchStyle(split[1]);
                }
            }
        });
        return values;
    }

    private static class Values {
        @Nullable Integer width;
        int prefix = 0;
        @Nullable String textStyle;
        @Nullable String matchStyle;

        private Values() {
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setPrefix(int prefix) {
            this.prefix = prefix;
        }

        public void setTextStyle(String textStyle) {
            this.textStyle = textStyle;
        }

        public void setMatchStyle(String matchStyle) {
            this.matchStyle = matchStyle;
        }
    }
}

