/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.command;

import java.io.FileWriter;
import java.io.PrintWriter;
import org.jline.reader.History;
import org.springframework.shell.core.command.Command;
import org.springframework.shell.core.command.CommandContext;
import org.springframework.shell.core.command.CommandOption;
import org.springframework.shell.core.command.ExitStatus;

public class History
implements Command {
    private final org.jline.reader.History jLineHistory;

    public History(org.jline.reader.History jLineHistory) {
        this.jLineHistory = jLineHistory;
    }

    public String getName() {
        return "history";
    }

    public String getDescription() {
        return "Display or save the history of previously run commands";
    }

    public String getGroup() {
        return "Built-In Commands";
    }

    public ExitStatus execute(CommandContext commandContext) throws Exception {
        PrintWriter outputWriter = commandContext.outputWriter();
        CommandOption fileOption = commandContext.getOptionByName("file");
        if (fileOption == null) {
            this.jLineHistory.forEach(e -> outputWriter.println(e.line()));
        } else {
            String fileName = fileOption.value();
            if (fileName == null || fileName.isEmpty()) {
                throw new IllegalArgumentException("File name must be provided");
            }
            try (FileWriter w = new FileWriter(fileName);){
                for (History.Entry entry : this.jLineHistory) {
                    w.append(entry.line()).append(System.lineSeparator());
                }
            }
            outputWriter.println(String.format("Wrote %d entries to %s", this.jLineHistory.size(), fileName));
        }
        outputWriter.flush();
        return ExitStatus.OK;
    }
}

