/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.table;

import java.util.Arrays;
import org.springframework.shell.jline.tui.table.Aligner;
import org.springframework.util.Assert;

public class DebugAligner
implements Aligner {
    private final Aligner delegate;

    public DebugAligner(Aligner delegate) {
        this.delegate = delegate;
    }

    @Override
    public String[] align(String[] text, int cellWidth, int cellHeight) {
        String[] result = this.delegate.align(text, cellWidth, cellHeight);
        Assert.isTrue((result.length == cellHeight ? 1 : 0) != 0, (String)String.format("%s had the wrong number of lines (%d), expected %d", Arrays.asList(result), result.length, cellHeight));
        for (String s : result) {
            Assert.isTrue((s.length() == cellWidth ? 1 : 0) != 0, (String)String.format("'%s' had wrong length (%d), expected %d", s, s.length(), cellWidth));
        }
        return result;
    }
}

