/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.context;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.context.ComponentContext;

public class BaseComponentContext<C extends ComponentContext<C>>
extends LinkedHashMap<Object, Object>
implements ComponentContext<C> {
    private @Nullable Integer terminalWidth;

    @Override
    public Object get(Object key) {
        Object o = super.get(key);
        if (o != null) {
            return o;
        }
        throw new NoSuchElementException("Context does not contain key: " + String.valueOf(key));
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        Object value = this.get(key);
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type specified for key '" + String.valueOf(key) + "'. Expected [" + String.valueOf(type) + "] but actual type is [" + String.valueOf(value.getClass()) + "]");
        }
        return (T)value;
    }

    @Override
    public ComponentContext<C> put(Object key, Object value) {
        super.put(key, value);
        return this;
    }

    @Override
    public Stream<Map.Entry<Object, Object>> stream() {
        return this.entrySet().stream();
    }

    @Override
    public @Nullable Integer getTerminalWidth() {
        return this.terminalWidth;
    }

    @Override
    public void setTerminalWidth(@Nullable Integer terminalWidth) {
        this.terminalWidth = terminalWidth;
    }

    @Override
    public Map<String, @Nullable Object> toTemplateModel() {
        HashMap<String, @Nullable Object> attributes = new HashMap<String, Object>();
        attributes.put("rawValues", this);
        attributes.put("terminalWidth", this.terminalWidth);
        return attributes;
    }

    @Override
    public String toString() {
        return "BaseComponentContext [terminalWidth=" + this.terminalWidth + "]";
    }
}

