/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.context.ComponentContext;
import org.springframework.shell.jline.tui.component.support.AbstractTextComponent;
import org.springframework.util.StringUtils;

public class ConfirmationInput
extends AbstractTextComponent<Boolean, ConfirmationInputContext> {
    private static final Log log = LogFactory.getLog(ConfirmationInput.class);
    private final boolean defaultValue;
    private @Nullable ConfirmationInputContext currentContext;

    public ConfirmationInput(Terminal terminal) {
        this(terminal, null);
    }

    public ConfirmationInput(Terminal terminal, @Nullable String name) {
        this(terminal, name, true, null);
    }

    public ConfirmationInput(Terminal terminal, @Nullable String name, boolean defaultValue) {
        this(terminal, name, defaultValue, null);
    }

    public ConfirmationInput(Terminal terminal, @Nullable String name, boolean defaultValue, @Nullable Function<ConfirmationInputContext, List<AttributedString>> renderer) {
        super(terminal, name, null);
        this.setRenderer(renderer != null ? renderer : new DefaultRenderer());
        this.setTemplateLocation("classpath:org/springframework/shell/component/confirmation-input-default.stg");
        this.defaultValue = defaultValue;
    }

    @Override
    public ConfirmationInputContext getThisContext(@Nullable ComponentContext<?> context) {
        if (context != null && this.currentContext == context) {
            return this.currentContext;
        }
        this.currentContext = ConfirmationInputContext.of(this.defaultValue);
        this.currentContext.setName(this.getName());
        if (context != null) {
            context.stream().forEach(e -> this.currentContext.put(e.getKey(), e.getValue()));
        }
        return this.currentContext;
    }

    @Override
    protected boolean read(BindingReader bindingReader, KeyMap<String> keyMap, ConfirmationInputContext context) {
        String operation = (String)bindingReader.readBinding(keyMap);
        log.debug((Object)("Binding read result " + operation));
        if (operation == null) {
            return true;
        }
        switch (operation) {
            case "CHAR": {
                String lastBinding = bindingReader.getLastBinding();
                Object input = context.getInput();
                input = input == null ? lastBinding : (String)input + lastBinding;
                context.setInput((String)input);
                this.checkInput((String)input, context);
                break;
            }
            case "BACKSPACE": {
                String input = context.getInput();
                if (StringUtils.hasLength((String)input)) {
                    input = input.length() > 1 ? input.substring(0, input.length() - 1) : null;
                }
                context.setInput(input);
                this.checkInput(input, context);
                break;
            }
            case "EXIT": {
                if (StringUtils.hasText((String)context.getInput())) {
                    context.setResultValue(this.parseBoolean(context.getInput()));
                } else if (context.getDefaultValue() != null) {
                    context.setResultValue(context.getDefaultValue());
                }
                return true;
            }
        }
        return false;
    }

    private @Nullable Boolean parseBoolean(@Nullable String input) {
        if (!StringUtils.hasText((String)input)) {
            return null;
        }
        switch (input = input.trim().toLowerCase()) {
            case "y": 
            case "yes": 
            case "1": {
                return true;
            }
            case "n": 
            case "no": 
            case "0": {
                return false;
            }
        }
        return null;
    }

    private void checkInput(@Nullable String input, ConfirmationInputContext context) {
        if (!StringUtils.hasText((String)input)) {
            context.setMessage(null);
            return;
        }
        Boolean yesno = this.parseBoolean(input);
        if (yesno == null) {
            String msg = String.format("Sorry, your input is invalid: '%s', try again", input);
            context.setMessage(msg, AbstractTextComponent.TextComponentContext.MessageLevel.ERROR);
        } else {
            context.setMessage(null);
        }
    }

    private class DefaultRenderer
    implements Function<ConfirmationInputContext, List<AttributedString>> {
        private DefaultRenderer() {
        }

        @Override
        public List<AttributedString> apply(ConfirmationInputContext context) {
            return ConfirmationInput.this.renderTemplateResource(context.toTemplateModel());
        }
    }

    public static interface ConfirmationInputContext
    extends AbstractTextComponent.TextComponentContext<Boolean, ConfirmationInputContext> {
        public @Nullable Boolean getDefaultValue();

        public void setDefaultValue(Boolean var1);

        public static ConfirmationInputContext empty() {
            return ConfirmationInputContext.of(null);
        }

        public static ConfirmationInputContext of(@Nullable Boolean defaultValue) {
            return new DefaultConfirmationInputContext(defaultValue);
        }
    }

    private static class DefaultConfirmationInputContext
    extends AbstractTextComponent.BaseTextComponentContext<Boolean, ConfirmationInputContext>
    implements ConfirmationInputContext {
        private @Nullable Boolean defaultValue;

        public DefaultConfirmationInputContext(@Nullable Boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public @Nullable Boolean getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public void setDefaultValue(Boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public Map<String, Object> toTemplateModel() {
            Map<String, @Nullable Object> attributes = super.toTemplateModel();
            attributes.put("defaultValue", this.getDefaultValue() != null ? this.getDefaultValue() : null);
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("model", attributes);
            return model;
        }
    }
}

