/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.view.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.view.screen.DisplayLines;
import org.springframework.shell.jline.tui.component.view.screen.Screen;
import org.springframework.shell.jline.tui.component.view.screen.ScreenItem;
import org.springframework.shell.jline.tui.geom.HorizontalAlign;
import org.springframework.shell.jline.tui.geom.Position;
import org.springframework.shell.jline.tui.geom.Rectangle;
import org.springframework.shell.jline.tui.geom.VerticalAlign;
import org.springframework.shell.jline.tui.style.ThemeResolver;
import org.springframework.util.Assert;

public class DefaultScreen
implements Screen,
DisplayLines {
    private static final Log log = LogFactory.getLog(DefaultScreen.class);
    private boolean showCursor;
    private Position cursorPosition = new Position(0, 0);
    private int rows = 0;
    private int columns = 0;
    private static char[] BOX_CHARS = new char[]{' ', '\u2574', '\u2575', '\u250c', '\u2576', '\u2500', '\u2510', '\u252c', '\u2577', '\u2514', '\u2502', '\u251c', '\u2518', '\u2534', '\u2524', '\u253c'};
    private Map<Integer, Layer> layers = new TreeMap<Integer, Layer>();

    public DefaultScreen() {
        this(0, 0);
    }

    public DefaultScreen(int rows, int columns) {
        this.resize(rows, columns);
    }

    @Override
    public Screen.WriterBuilder writerBuilder() {
        return new DefaultWriterBuilder();
    }

    @Override
    public void setShowCursor(boolean showCursor) {
        this.showCursor = showCursor;
    }

    @Override
    public boolean isShowCursor() {
        return this.showCursor;
    }

    @Override
    public void setCursorPosition(Position cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    @Override
    public Position getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    public void resize(int rows, int columns) {
        Assert.isTrue((rows > -1 ? 1 : 0) != 0, (String)"Cannot have negative rows size");
        Assert.isTrue((columns > -1 ? 1 : 0) != 0, (String)"Cannot have negative columns size");
        this.rows = rows;
        this.columns = columns;
        this.reset();
        log.trace((Object)String.format("Screen reset rows=%s cols=%s", this.rows, this.columns));
    }

    @Override
    public ScreenItem[][] getItems() {
        return this.getScreenItems();
    }

    @Override
    public @Nullable Screen clip(int x, int y, int width, int height) {
        return null;
    }

    @Override
    public List<AttributedString> getScreenLines() {
        ArrayList<AttributedString> newLines = new ArrayList<AttributedString>();
        ScreenItem[][] items = this.getScreenItems();
        for (int i = 0; i < items.length; ++i) {
            AttributedStringBuilder builder = new AttributedStringBuilder();
            for (int j = 0; j < items[i].length; ++j) {
                DefaultScreenItem item = (DefaultScreenItem)items[i][j];
                if (item != null) {
                    AttributedStyle s = new AttributedStyle(AttributedStyle.DEFAULT);
                    if (item.background > -1) {
                        s = s.backgroundRgb(item.getBackground());
                    }
                    if (item.foreground > -1) {
                        s = s.foregroundRgb(item.getForeground());
                    }
                    if (item.style > -1) {
                        if ((item.style & 1) == 1) {
                            s = s.bold();
                        }
                        if ((item.style & 2) == 2) {
                            s = s.faint();
                        }
                        if ((item.style & 4) == 4) {
                            s = s.italic();
                        }
                        if ((item.style & 8) == 8) {
                            s = s.underline();
                        }
                        if ((item.style & 0x10) == 16) {
                            s = s.blink();
                        }
                        if ((item.style & 0x20) == 32) {
                            s = s.inverse();
                        }
                        if ((item.style & 0x40) == 64) {
                            s = s.conceal();
                        }
                        if ((item.style & 0x80) == 128) {
                            s = s.crossedOut();
                        }
                    }
                    if (item.getContent() != null) {
                        builder.append(item.getContent(), s);
                        continue;
                    }
                    if (item.getBorder() > 0) {
                        builder.append((CharSequence)Character.toString(BOX_CHARS[item.getBorder()]), s);
                        continue;
                    }
                    builder.append((CharSequence)Character.toString(' '), s);
                    continue;
                }
                builder.append(' ');
            }
            newLines.add(builder.toAttributedString());
        }
        return newLines;
    }

    private void reset() {
        this.layers.clear();
    }

    private Layer getLayer(int index) {
        Layer layer = this.layers.computeIfAbsent(index, l -> new Layer());
        return layer;
    }

    public ScreenItem[][] getScreenItems() {
        ScreenItem[][] projection = new DefaultScreenItem[this.rows][this.columns];
        this.layers.entrySet().stream().forEach(arg_0 -> this.lambda$getScreenItems$1((DefaultScreenItem[][])projection, arg_0));
        return projection;
    }

    private /* synthetic */ void lambda$getScreenItems$1(DefaultScreenItem[][] projection, Map.Entry entry) {
        Layer layer = (Layer)entry.getValue();
        DefaultScreenItem[][] layerItems = layer.items;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                if (layerItems[i][j] == null) continue;
                projection[i][j] = layerItems[i][j];
            }
        }
    }

    private class DefaultWriterBuilder
    implements Screen.WriterBuilder {
        int layer;
        int color = -1;
        int style = -1;

        private DefaultWriterBuilder() {
        }

        @Override
        public Screen.Writer build() {
            return new DefaultWriter(this.layer, this.color, this.style);
        }

        @Override
        public Screen.WriterBuilder layer(int index) {
            this.layer = index;
            return this;
        }

        @Override
        public Screen.WriterBuilder color(int color) {
            this.color = color;
            return this;
        }

        @Override
        public Screen.WriterBuilder style(int style) {
            this.style = style;
            return this;
        }
    }

    private static class DefaultScreenItem
    implements ScreenItem {
        @Nullable CharSequence content;
        int foreground = -1;
        int background = -1;
        int style = -1;
        int border;

        private DefaultScreenItem() {
        }

        @Override
        public @Nullable CharSequence getContent() {
            return this.content;
        }

        @Override
        public int getBorder() {
            return this.border;
        }

        @Override
        public int getBackground() {
            return this.background;
        }

        @Override
        public int getForeground() {
            return this.foreground;
        }

        @Override
        public int getStyle() {
            return this.style;
        }
    }

    private class Layer {
        DefaultScreenItem[][] items;

        private Layer() {
            this.items = new DefaultScreenItem[DefaultScreen.this.rows][DefaultScreen.this.columns];
        }

        @Nullable DefaultScreenItem getScreenItem(int x, int y) {
            if (y < DefaultScreen.this.rows && x < DefaultScreen.this.columns) {
                if (this.items[y][x] == null) {
                    this.items[y][x] = new DefaultScreenItem();
                }
                return this.items[y][x];
            }
            return null;
        }
    }

    private class DefaultWriter
    implements Screen.Writer {
        int index;
        int color = -1;
        int style = -1;

        DefaultWriter(int index, int color, int style) {
            this.index = index;
            this.color = color;
            this.style = style;
        }

        @Override
        public void text(String text, int x, int y) {
            Layer layer = DefaultScreen.this.getLayer(this.index);
            for (int i = 0; i < text.length() && i < DefaultScreen.this.columns; ++i) {
                char c = text.charAt(i);
                DefaultScreenItem item = layer.getScreenItem(x + i, y);
                if (item == null) continue;
                item.content = Character.toString(c);
                if (this.color > -1) {
                    item.foreground = this.color;
                }
                if (this.style <= -1) continue;
                item.style = this.style;
            }
        }

        @Override
        public void text(AttributedString text, int x, int y) {
            Layer layer = DefaultScreen.this.getLayer(this.index);
            for (int i = 0; i < text.length() && i < DefaultScreen.this.columns; ++i) {
                DefaultScreenItem item = layer.getScreenItem(x + i, y);
                if (item == null) continue;
                char c = text.charAt(i);
                AttributedStyle as = text.styleAt(i);
                ThemeResolver.ResolvedValues rv = ThemeResolver.resolveValues(as);
                item.content = Character.toString(c);
                if (rv.foreground() > -1) {
                    item.foreground = rv.foreground();
                }
                if (rv.style() > -1) {
                    item.style = rv.style();
                }
                if (rv.background() <= -1) continue;
                item.background = rv.background();
            }
        }

        @Override
        public void border(int x, int y, int width, int height) {
            log.trace((Object)String.format("PrintBorder rows=%s}, columns=%s, x=%s, y=%s, width=%s, height=%s", DefaultScreen.this.rows, DefaultScreen.this.columns, x, y, width, height));
            this.printBorderHorizontal(x, y, width);
            this.printBorderHorizontal(x, y + height - 1, width);
            this.printBorderVertical(x, y, height);
            this.printBorderVertical(x + width - 1, y, height);
        }

        @Override
        public void background(Rectangle rect, int color) {
            log.trace((Object)String.format("Background %s %s", color, rect));
            Layer layer = DefaultScreen.this.getLayer(this.index);
            for (int i = rect.y(); i < rect.y() + rect.height(); ++i) {
                for (int j = rect.x(); j < rect.x() + rect.width(); ++j) {
                    DefaultScreenItem item = layer.getScreenItem(j, i);
                    if (item == null) continue;
                    item.background = color;
                }
            }
        }

        @Override
        public void text(String text, Rectangle rect, @Nullable HorizontalAlign hAlign, @Nullable VerticalAlign vAlign) {
            int x = rect.x();
            if (hAlign == HorizontalAlign.CENTER) {
                x += rect.width() / 2;
                x -= text.length() / 2;
            } else if (hAlign == HorizontalAlign.RIGHT) {
                x = x + rect.width() - text.length();
            }
            int y = rect.y();
            if (vAlign == VerticalAlign.CENTER) {
                y += rect.height() / 2;
            } else if (vAlign == VerticalAlign.BOTTOM) {
                y = y + rect.height() - 1;
            }
            this.text(text, x, y);
        }

        private void printBorderHorizontal(int x, int y, int width) {
            Layer layer = DefaultScreen.this.getLayer(this.index);
            for (int i = x; i < x + width; ++i) {
                DefaultScreenItem item;
                if (i < 0 || i >= DefaultScreen.this.columns || y >= DefaultScreen.this.rows || (item = layer.getScreenItem(i, y)) == null) continue;
                if (i > x) {
                    item.border |= 4;
                }
                if (i >= x + width - 1) continue;
                item.border |= 1;
            }
        }

        private void printBorderVertical(int x, int y, int height) {
            Layer layer = DefaultScreen.this.getLayer(this.index);
            for (int i = y; i < y + height; ++i) {
                DefaultScreenItem item;
                if (i < 0 || i >= DefaultScreen.this.rows || x >= DefaultScreen.this.columns || (item = layer.getScreenItem(x, i)) == null) continue;
                if (i > y) {
                    item.border |= 8;
                }
                if (i >= y + height - 1) continue;
                item.border |= 2;
            }
        }
    }
}

