/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.message;

import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.Message;
import org.springframework.shell.jline.tui.component.view.control.View;
import org.springframework.shell.jline.tui.component.view.event.EventLoop;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public final class StaticShellMessageHeaderAccessor {
    private StaticShellMessageHeaderAccessor() {
    }

    public static @Nullable UUID getId(Message<?> message) {
        Object value = message.getHeaders().get((Object)"id");
        if (value == null) {
            return null;
        }
        return value instanceof UUID ? (UUID)value : UUID.fromString(value.toString());
    }

    public static @Nullable Long getTimestamp(Message<?> message) {
        Object value = message.getHeaders().get((Object)"timestamp");
        if (value == null) {
            return null;
        }
        return value instanceof Long ? (Long)value : Long.parseLong(value.toString());
    }

    public static @Nullable Integer getPriority(Message<?> message) {
        Number priority = (Number)message.getHeaders().get((Object)"priority", Number.class);
        return priority != null ? Integer.valueOf(priority.intValue()) : null;
    }

    public static @Nullable View getView(Message<?> message) {
        View view = (View)message.getHeaders().get((Object)"view", View.class);
        return view;
    }

    public static ContextView getReactorContext(Message<?> message) {
        ContextView reactorContext = (ContextView)message.getHeaders().get((Object)"reactorContext", ContextView.class);
        if (reactorContext == null) {
            reactorContext = Context.empty();
        }
        return reactorContext;
    }

    public static  @Nullable EventLoop.Type getEventType(Message<?> message) {
        return (EventLoop.Type)((Object)message.getHeaders().get((Object)"eventType", EventLoop.Type.class));
    }
}

