/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.jdbc.config.annotation.web.http;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.jdbc.JdbcOperationsSessionRepository;
import org.springframework.session.jdbc.config.annotation.web.http.EnableJdbcHttpSession;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration
@EnableScheduling
public class JdbcHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements BeanClassLoaderAware,
ImportAware,
EmbeddedValueResolverAware {
    private String tableName;
    private Integer maxInactiveIntervalInSeconds;
    private LobHandler lobHandler;
    @Autowired(required=false)
    @Qualifier(value="conversionService")
    private ConversionService conversionService;
    private ConversionService springSessionConversionService;
    private ClassLoader classLoader;
    private StringValueResolver embeddedValueResolver;

    @Bean
    public JdbcTemplate springSessionJdbcOperations(DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean
    public JdbcOperationsSessionRepository sessionRepository(@Qualifier(value="springSessionJdbcOperations") JdbcOperations jdbcOperations, PlatformTransactionManager transactionManager) {
        JdbcOperationsSessionRepository sessionRepository = new JdbcOperationsSessionRepository(jdbcOperations, transactionManager);
        String tableName = this.getTableName();
        if (StringUtils.hasText((String)tableName)) {
            sessionRepository.setTableName(tableName);
        }
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        if (this.lobHandler != null) {
            sessionRepository.setLobHandler(this.lobHandler);
        }
        if (this.springSessionConversionService != null) {
            sessionRepository.setConversionService(this.springSessionConversionService);
        } else if (this.conversionService != null) {
            sessionRepository.setConversionService(this.conversionService);
        } else if (this.deserializingConverterSupportsCustomClassLoader()) {
            GenericConversionService conversionService = this.createConversionServiceWithBeanClassLoader();
            sessionRepository.setConversionService((ConversionService)conversionService);
        }
        return sessionRepository;
    }

    private GenericConversionService createConversionServiceWithBeanClassLoader() {
        GenericConversionService conversionService = new GenericConversionService();
        conversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        conversionService.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter(this.classLoader));
        return conversionService;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionLobHandler")
    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionConversionService")
    public void setSpringSessionConversionService(ConversionService conversionService) {
        this.springSessionConversionService = conversionService;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    private String getTableName() {
        String systemProperty = System.getProperty("spring.session.jdbc.tableName", "");
        if (StringUtils.hasText((String)systemProperty)) {
            return systemProperty;
        }
        return this.tableName;
    }

    private boolean deserializingConverterSupportsCustomClassLoader() {
        return ClassUtils.hasConstructor(DeserializingConverter.class, (Class[])new Class[]{ClassLoader.class});
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableAttrMap = importMetadata.getAnnotationAttributes(EnableJdbcHttpSession.class.getName());
        AnnotationAttributes enableAttrs = AnnotationAttributes.fromMap((Map)enableAttrMap);
        String tableNameValue = enableAttrs.getString("tableName");
        if (StringUtils.hasText((String)tableNameValue)) {
            this.tableName = this.embeddedValueResolver.resolveStringValue(tableNameValue);
        }
        this.maxInactiveIntervalInSeconds = (Integer)enableAttrs.getNumber("maxInactiveIntervalInSeconds");
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }
}

