/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis.config.annotation.web.http;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.session.FlushMode;
import org.springframework.session.SaveMode;
import org.springframework.session.SessionIdGenerator;
import org.springframework.session.SessionRepository;
import org.springframework.session.UuidSessionIdGenerator;
import org.springframework.session.data.redis.RedisSessionRepository;
import org.springframework.session.data.redis.config.annotation.web.http.AbstractRedisHttpSessionConfiguration;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration(proxyBeanMethods=false)
public class RedisHttpSessionConfiguration
extends AbstractRedisHttpSessionConfiguration<RedisSessionRepository>
implements EmbeddedValueResolverAware,
ImportAware {
    private @Nullable StringValueResolver embeddedValueResolver;
    private SessionIdGenerator sessionIdGenerator = UuidSessionIdGenerator.getInstance();

    @Override
    @Bean
    public RedisSessionRepository sessionRepository() {
        RedisTemplate<String, Object> redisTemplate = this.createRedisTemplate();
        RedisSessionRepository sessionRepository = new RedisSessionRepository((RedisOperations<String, Object>)redisTemplate);
        sessionRepository.setDefaultMaxInactiveInterval(this.getMaxInactiveInterval());
        if (StringUtils.hasText((String)this.getRedisNamespace())) {
            sessionRepository.setRedisKeyNamespace(this.getRedisNamespace());
        }
        sessionRepository.setFlushMode(this.getFlushMode());
        sessionRepository.setSaveMode(this.getSaveMode());
        sessionRepository.setSessionIdGenerator(this.sessionIdGenerator);
        this.getSessionRepositoryCustomizers().forEach(sessionRepositoryCustomizer -> sessionRepositoryCustomizer.customize((SessionRepository)sessionRepository));
        return sessionRepository;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        @Nullable @Nullable Map attributeMap = importMetadata.getAnnotationAttributes(EnableRedisHttpSession.class.getName());
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
        if (attributes == null) {
            return;
        }
        this.setMaxInactiveInterval(Duration.ofSeconds(((Integer)attributes.getNumber("maxInactiveIntervalInSeconds")).intValue()));
        String redisNamespaceValue = attributes.getString("redisNamespace");
        if (StringUtils.hasText((String)redisNamespaceValue) && this.embeddedValueResolver != null) {
            String namespace = this.embeddedValueResolver.resolveStringValue(redisNamespaceValue);
            this.setRedisNamespace(Objects.requireNonNull(namespace));
        }
        this.setFlushMode((FlushMode)attributes.getEnum("flushMode"));
        this.setSaveMode((SaveMode)attributes.getEnum("saveMode"));
    }

    @Autowired(required=false)
    public void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
    }
}

