/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.expiration.repository;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.apache.shiro.util.Assert;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;

public class FixedDurationExpirationSessionRepository<S extends Session>
implements SessionRepository<S> {
    private final SessionRepository<S> delegate;
    private final Duration expirationTimeout;

    public FixedDurationExpirationSessionRepository(@NonNull SessionRepository<S> sessionRepository, @Nullable Duration expirationTimeout) {
        Assert.notNull(sessionRepository, (String)"SessionRepository is required");
        this.delegate = sessionRepository;
        this.expirationTimeout = expirationTimeout;
    }

    @NonNull
    protected SessionRepository<S> getDelegate() {
        return this.delegate;
    }

    public Optional<Duration> getExpirationTimeout() {
        return Optional.ofNullable(this.expirationTimeout);
    }

    public S createSession() {
        return (S)this.getDelegate().createSession();
    }

    public S findById(String id) {
        return (S)((Session)Optional.ofNullable(this.getDelegate().findById(id)).map(session -> this.getExpirationTimeout().map(expirationDuration -> this.handleExpired((S)session, (Duration)expirationDuration)).orElseGet(() -> this.getExpirationTimeout().isPresent() ? null : session)).orElse(null));
    }

    S handleExpired(S session, Duration expirationDuration) {
        if (this.isExpired(session, expirationDuration)) {
            this.deleteById(session.getId());
            session = null;
        }
        return session;
    }

    boolean isExpired(S session, Duration expirationDuration) {
        Instant sessionCreationTime = session.getCreationTime();
        Instant now = Instant.now();
        return now.minusMillis(expirationDuration.toMillis()).isAfter(sessionCreationTime);
    }

    public void save(S session) {
        this.getDelegate().save(session);
    }

    public void deleteById(String id) {
        this.getDelegate().deleteById(id);
    }
}

