/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.serialization.data.support;

import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.wiring.BeanConfigurerSupport;
import org.springframework.data.gemfire.support.GemfireBeanFactoryLocator;
import org.springframework.session.data.gemfire.serialization.data.AbstractDataSerializableSessionSerializer;

abstract class WirableDataSerializer<T>
extends AbstractDataSerializableSessionSerializer<T> {
    WirableDataSerializer() {
    }

    protected final void autowire() {
        this.locateBeanFactory().map(this::newBeanConfigurer).ifPresent(beanConfigurer -> {
            beanConfigurer.configureBean((Object)this);
            beanConfigurer.destroy();
        });
    }

    Optional<BeanFactory> locateBeanFactory() {
        try {
            return Optional.ofNullable(GemfireBeanFactoryLocator.newBeanFactoryLocator().useBeanFactory());
        }
        catch (Exception ignore) {
            return Optional.empty();
        }
    }

    BeanConfigurerSupport newBeanConfigurer(BeanFactory beanFactory) {
        BeanConfigurerSupport beanConfigurer = new BeanConfigurerSupport();
        beanConfigurer.setBeanFactory(beanFactory);
        beanConfigurer.afterPropertiesSet();
        return beanConfigurer;
    }
}

