/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.serialization.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.apache.geode.DataSerializer;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.session.data.gemfire.serialization.SerializationException;
import org.springframework.session.data.gemfire.serialization.SessionSerializer;

public abstract class AbstractDataSerializableSessionSerializer<T>
extends DataSerializer
implements SessionSerializer<T, DataInput, DataOutput> {
    protected static final boolean DEFAULT_ALLOW_JAVA_SERIALIZATION = true;

    public int getId() {
        return 168930533;
    }

    public Class<?>[] getSupportedClasses() {
        return new Class[0];
    }

    protected boolean allowJavaSerialization() {
        return true;
    }

    public boolean toData(Object session, DataOutput out) throws IOException {
        return Optional.ofNullable(session).filter(this::canSerialize).map(it -> {
            this.serialize(session, out);
            return true;
        }).orElse(false);
    }

    public void serializeObject(Object obj, DataOutput out) throws IOException {
        this.serializeObject(obj, out, this.allowJavaSerialization());
    }

    public void serializeObject(Object obj, DataOutput out, boolean allowJavaSerialization) throws IOException {
        AbstractDataSerializableSessionSerializer.writeObject((Object)obj, (DataOutput)out, (boolean)allowJavaSerialization);
    }

    public Object fromData(DataInput in) throws IOException, ClassNotFoundException {
        return this.deserialize(in);
    }

    public <T> T deserializeObject(DataInput in) throws ClassNotFoundException, IOException {
        return (T)DataSerializer.readObject((DataInput)in);
    }

    @Override
    public boolean canSerialize(Class<?> type) {
        return Arrays.stream(ArrayUtils.nullSafeArray((Object[])this.getSupportedClasses(), Class.class)).filter(it -> type != null).anyMatch(supportedClass -> supportedClass.isAssignableFrom(type));
    }

    protected <T> T safeRead(DataInput in, DataInputReader<T> reader) {
        try {
            return reader.doRead(in);
        }
        catch (IOException | ClassNotFoundException cause) {
            throw new SerializationException(cause);
        }
    }

    protected void safeWrite(DataOutput out, DataOutputWriter writer) {
        try {
            writer.doWrite(out);
        }
        catch (IOException cause) {
            throw new SerializationException(cause);
        }
    }

    protected static interface DataOutputWriter {
        public void doWrite(DataOutput var1) throws IOException;
    }

    protected static interface DataInputReader<T> {
        public T doRead(DataInput var1) throws ClassNotFoundException, IOException;
    }
}

