/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.config.annotation.web.http.support;

import java.util.Optional;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.data.gemfire.config.annotation.support.CacheTypeAwareRegionFactoryBean;
import org.springframework.session.data.gemfire.config.annotation.web.http.GemFireHttpSessionConfiguration;
import org.springframework.session.data.gemfire.support.GemFireUtils;
import org.springframework.util.StringUtils;

public class GemFireCacheTypeAwareRegionFactoryBean<K, V>
extends CacheTypeAwareRegionFactoryBean<K, V> {
    protected static final ClientRegionShortcut DEFAULT_CLIENT_REGION_SHORTCUT = GemFireHttpSessionConfiguration.DEFAULT_CLIENT_REGION_SHORTCUT;
    protected static final RegionShortcut DEFAULT_SERVER_REGION_SHORTCUT = GemFireHttpSessionConfiguration.DEFAULT_SERVER_REGION_SHORTCUT;
    protected static final String DEFAULT_POOL_NAME = "gemfirePool";
    protected static final String DEFAULT_SESSION_REGION_NAME = "ClusteredSpringSessions";
    private String regionName;

    public void setClientRegionShortcut(ClientRegionShortcut clientRegionShortcut) {
        super.setClientRegionShortcut(clientRegionShortcut != null ? clientRegionShortcut : DEFAULT_CLIENT_REGION_SHORTCUT);
    }

    public ClientRegionShortcut getClientRegionShortcut() {
        return super.getClientRegionShortcut();
    }

    protected Interest<K>[] getInterests() {
        ClientRegionShortcut clientRegionShortcut = this.getClientRegionShortcut();
        return this.registerInterests(clientRegionShortcut != null && !GemFireUtils.isLocal(clientRegionShortcut));
    }

    protected Interest<K>[] registerInterests(boolean register) {
        Interest[] interestArray;
        if (register) {
            Interest[] interestArray2 = new Interest[1];
            interestArray = interestArray2;
            interestArray2[0] = new Interest((Object)"ALL_KEYS", InterestResultPolicy.KEYS);
        } else {
            interestArray = new Interest[]{};
        }
        return interestArray;
    }

    protected Optional<String> getPoolName() {
        return Optional.of(super.getPoolName().orElse(DEFAULT_POOL_NAME));
    }

    @Deprecated
    public void setRegionAttributes(RegionAttributes<K, V> regionAttributes) {
        this.setAttributes(regionAttributes);
    }

    @Deprecated
    protected RegionAttributes<K, V> getRegionAttributes() {
        return this.getAttributes();
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    protected String getRegionName() {
        return Optional.ofNullable(this.regionName).filter(StringUtils::hasText).orElse(DEFAULT_SESSION_REGION_NAME);
    }

    public String resolveRegionName() {
        return this.getRegionName();
    }

    public RegionShortcut getServerRegionShortcut() {
        return Optional.ofNullable(super.getServerRegionShortcut()).orElse(DEFAULT_SERVER_REGION_SHORTCUT);
    }
}

