/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.cache.query.SelectResults;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.AbstractGemFireOperationsSessionRepository;

public class GemFireOperationsSessionRepository
extends AbstractGemFireOperationsSessionRepository {
    protected static final String FIND_SESSIONS_BY_INDEX_NAME_INDEX_VALUE_QUERY = "SELECT s FROM %1$s s WHERE s.attributes['%2$s'] = $1";
    protected static final String FIND_SESSIONS_BY_PRINCIPAL_NAME_QUERY = "SELECT s FROM %1$s s WHERE s.principalName = $1";

    public GemFireOperationsSessionRepository(GemfireOperations template) {
        super(template);
    }

    public Map<String, Session> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        SelectResults results = this.getTemplate().find(this.prepareQuery(indexName), new Object[]{indexValue});
        HashMap<String, Session> sessions = new HashMap<String, Session>(results.size());
        results.asList().forEach(session -> sessions.put(session.getId(), (Session)session));
        return sessions;
    }

    protected String prepareQuery(String indexName) {
        return PRINCIPAL_NAME_INDEX_NAME.equals(indexName) ? String.format(FIND_SESSIONS_BY_PRINCIPAL_NAME_QUERY, this.getFullyQualifiedRegionName()) : String.format(FIND_SESSIONS_BY_INDEX_NAME_INDEX_VALUE_QUERY, this.getFullyQualifiedRegionName(), indexName);
    }

    public Session createSession() {
        return AbstractGemFireOperationsSessionRepository.GemFireSession.create(this.getMaxInactiveInterval());
    }

    public Session findById(String sessionId) {
        Session storedSession = (Session)this.getTemplate().get((Object)sessionId);
        if (storedSession != null) {
            storedSession = storedSession.isExpired() ? this.delete(storedSession) : this.touch(AbstractGemFireOperationsSessionRepository.GemFireSession.from(storedSession));
        }
        return storedSession;
    }

    public void save(Session session) {
        this.getTemplate().put((Object)session.getId(), AbstractGemFireOperationsSessionRepository.GemFireSession.from(session));
    }

    public void deleteById(String sessionId) {
        this.handleDeleted(sessionId, this.toSession(this.getTemplate().remove((Object)sessionId), sessionId));
    }
}

