/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.gemfire.GemfireAccessor;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.config.annotation.web.http.GemFireHttpSessionConfiguration;
import org.springframework.session.data.gemfire.support.GemFireUtils;
import org.springframework.session.data.gemfire.support.SessionIdHolder;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractGemFireOperationsSessionRepository
extends CacheListenerAdapter<Object, Session>
implements ApplicationEventPublisherAware,
FindByIndexNameSessionRepository<Session>,
InitializingBean {
    private static final AtomicBoolean usingDataSerialization = new AtomicBoolean(false);
    private ApplicationEventPublisher applicationEventPublisher = event -> {};
    private Duration maxInactiveInterval = Duration.ofSeconds(GemFireHttpSessionConfiguration.DEFAULT_MAX_INACTIVE_INTERVAL_IN_SECONDS);
    private final GemfireOperations template;
    private final Log logger = this.newLogger();
    private final Set<Integer> cachedSessionIds = new ConcurrentSkipListSet<Integer>();
    private String fullyQualifiedRegionName;

    public AbstractGemFireOperationsSessionRepository(GemfireOperations template) {
        Assert.notNull((Object)template, (String)"GemfireOperations is required");
        this.template = template;
    }

    private Log newLogger() {
        return LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        Assert.notNull((Object)applicationEventPublisher, (String)"ApplicationEventPublisher is required");
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    protected String getFullyQualifiedRegionName() {
        return this.fullyQualifiedRegionName;
    }

    protected Log getLogger() {
        return this.logger;
    }

    public void setMaxInactiveInterval(Duration maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public Duration getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.setMaxInactiveInterval(Duration.ofSeconds(maxInactiveIntervalInSeconds));
    }

    public int getMaxInactiveIntervalInSeconds() {
        return Optional.ofNullable(this.getMaxInactiveInterval()).map(Duration::getSeconds).map(Long::intValue).orElse(0);
    }

    public void setUseDataSerialization(boolean useDataSerialization) {
        usingDataSerialization.set(useDataSerialization);
    }

    protected static boolean isUsingDataSerialization() {
        return usingDataSerialization.get();
    }

    public GemfireOperations getTemplate() {
        return this.template;
    }

    public void afterPropertiesSet() throws Exception {
        GemfireOperations template = this.getTemplate();
        Assert.isInstanceOf(GemfireAccessor.class, (Object)template);
        Region region = ((GemfireAccessor)template).getRegion();
        this.fullyQualifiedRegionName = region.getFullPath();
        AttributesMutator attributesMutator = region.getAttributesMutator();
        attributesMutator.addCacheListener((CacheListener)this);
    }

    boolean isCreate(EntryEvent<?, ?> event) {
        return this.isCreate(event.getOperation()) && this.isNotUpdate(event) && this.isSession(event.getNewValue());
    }

    private boolean isCreate(Operation operation) {
        return operation.isCreate() && !Operation.LOCAL_LOAD_CREATE.equals(operation);
    }

    private boolean isNotUpdate(EntryEvent event) {
        return this.isNotProxyRegion() || !this.cachedSessionIds.contains(ObjectUtils.nullSafeHashCode((Object)event.getKey()));
    }

    private boolean isNotProxyRegion() {
        return !this.isProxyRegion();
    }

    private boolean isProxyRegion() {
        return GemFireUtils.isProxy(((GemfireAccessor)this.getTemplate()).getRegion());
    }

    private boolean isSession(Object obj) {
        return obj instanceof Session;
    }

    boolean forget(Object sessionId) {
        return this.cachedSessionIds.remove(ObjectUtils.nullSafeHashCode((Object)sessionId));
    }

    boolean remember(Object sessionId) {
        return this.isProxyRegion() && this.cachedSessionIds.add(ObjectUtils.nullSafeHashCode((Object)sessionId));
    }

    Session toSession(Object obj, String sessionId) {
        return obj instanceof Session ? (Session)obj : (Session)Optional.ofNullable(sessionId).filter(StringUtils::hasText).map(SessionIdHolder::create).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"Minimally, the session ID [%s] must be known to trigger a Session event", (Object[])new Object[]{sessionId}));
    }

    public void afterCreate(EntryEvent<Object, Session> event) {
        Optional.ofNullable(event).filter(this::isCreate).ifPresent(it -> {
            String sessionId = it.getKey().toString();
            this.handleCreated(sessionId, this.toSession(it.getNewValue(), sessionId));
        });
    }

    public void afterDestroy(EntryEvent<Object, Session> event) {
        Optional.ofNullable(event).ifPresent(it -> {
            String sessionId = event.getKey().toString();
            this.handleDestroyed(sessionId, this.toSession(event.getOldValue(), sessionId));
        });
    }

    public void afterInvalidate(EntryEvent<Object, Session> event) {
        Optional.ofNullable(event).ifPresent(it -> {
            String sessionId = event.getKey().toString();
            this.handleExpired(sessionId, this.toSession(event.getOldValue(), sessionId));
        });
    }

    protected Session delete(Session session) {
        this.deleteById(session.getId());
        return null;
    }

    protected void handleCreated(String sessionId, Session session) {
        this.remember(sessionId);
        this.publishEvent((ApplicationEvent)this.newSessionCreatedEvent(session));
    }

    protected void handleDeleted(String sessionId, Session session) {
        this.forget(sessionId);
        this.publishEvent((ApplicationEvent)this.newSessionDeletedEvent(session));
    }

    protected void handleDestroyed(String sessionId, Session session) {
        this.forget(sessionId);
        this.publishEvent((ApplicationEvent)this.newSessionDestroyedEvent(session));
    }

    protected void handleExpired(String sessionId, Session session) {
        this.forget(sessionId);
        this.publishEvent((ApplicationEvent)this.newSessionExpiredEvent(session));
    }

    private SessionCreatedEvent newSessionCreatedEvent(Session session) {
        return new SessionCreatedEvent((Object)this, session);
    }

    private SessionDeletedEvent newSessionDeletedEvent(Session session) {
        return new SessionDeletedEvent((Object)this, session);
    }

    private SessionDestroyedEvent newSessionDestroyedEvent(Session session) {
        return new SessionDestroyedEvent((Object)this, session);
    }

    private SessionExpiredEvent newSessionExpiredEvent(Session session) {
        return new SessionExpiredEvent((Object)this, session);
    }

    protected void publishEvent(ApplicationEvent event) {
        try {
            this.getApplicationEventPublisher().publishEvent(event);
        }
        catch (Throwable cause) {
            this.getLogger().error((Object)String.format("Error occurred while publishing event [%s]", event), cause);
        }
    }

    protected <T extends Session> T touch(T session) {
        session.setLastAccessedTime(Instant.now());
        return session;
    }

    public static class GemFireSessionAttributes
    extends AbstractMap<String, Object> {
        private final transient Map<String, Object> sessionAttributes = new HashMap<String, Object>();
        private final transient Object lock;

        protected GemFireSessionAttributes() {
            this.lock = this;
        }

        protected GemFireSessionAttributes(Object lock) {
            this.lock = lock != null ? lock : this;
        }

        public static GemFireSessionAttributes create() {
            return new GemFireSessionAttributes();
        }

        public static GemFireSessionAttributes create(Object lock) {
            return new GemFireSessionAttributes(lock);
        }

        protected Object getLock() {
            return this.lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object setAttribute(String attributeName, Object attributeValue) {
            Object object = this.getLock();
            synchronized (object) {
                return attributeValue != null ? this.sessionAttributes.put(attributeName, attributeValue) : this.removeAttribute(attributeName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object removeAttribute(String attributeName) {
            Object object = this.getLock();
            synchronized (object) {
                return this.sessionAttributes.remove(attributeName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T getAttribute(String attributeName) {
            Object object = this.getLock();
            synchronized (object) {
                return (T)this.sessionAttributes.get(attributeName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> getAttributeNames() {
            Object object = this.getLock();
            synchronized (object) {
                return Collections.unmodifiableSet(new HashSet<String>(this.sessionAttributes.keySet()));
            }
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AbstractSet<Map.Entry<String, Object>>(){

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    return Collections.unmodifiableMap(sessionAttributes).entrySet().iterator();
                }

                @Override
                public int size() {
                    return sessionAttributes.size();
                }
            };
        }

        public void clearDelta() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void from(Session session) {
            Object object = this.getLock();
            synchronized (object) {
                session.getAttributeNames().forEach((? super T attributeName) -> this.setAttribute((String)attributeName, session.getAttribute(attributeName)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void from(Map<String, Object> map) {
            Object object = this.getLock();
            synchronized (object) {
                map.forEach(this::setAttribute);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void from(GemFireSessionAttributes sessionAttributes) {
            Object object = this.getLock();
            synchronized (object) {
                sessionAttributes.getAttributeNames().forEach((? super T attributeName) -> this.setAttribute((String)attributeName, sessionAttributes.getAttribute((String)attributeName)));
            }
        }

        public boolean hasDelta() {
            return false;
        }

        @Override
        public String toString() {
            return this.sessionAttributes.toString();
        }
    }

    public static class DeltaCapableGemFireSessionAttributes
    extends GemFireSessionAttributes
    implements Delta {
        private final transient Map<String, Object> sessionAttributeDeltas = new HashMap<String, Object>();

        public DeltaCapableGemFireSessionAttributes() {
        }

        public DeltaCapableGemFireSessionAttributes(Object lock) {
            super(lock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object setAttribute(String attributeName, Object attributeValue) {
            Object object = this.getLock();
            synchronized (object) {
                if (attributeValue != null) {
                    Object previousAttributeValue = super.setAttribute(attributeName, attributeValue);
                    if (!attributeValue.equals(previousAttributeValue)) {
                        this.sessionAttributeDeltas.put(attributeName, attributeValue);
                    }
                    return previousAttributeValue;
                }
                return this.removeAttribute(attributeName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object removeAttribute(String attributeName) {
            Object object = this.getLock();
            synchronized (object) {
                return Optional.ofNullable(super.removeAttribute(attributeName)).map(previousAttributeValue -> {
                    this.sessionAttributeDeltas.put(attributeName, null);
                    return previousAttributeValue;
                }).orElse(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toDelta(DataOutput out) throws IOException {
            Object object = this.getLock();
            synchronized (object) {
                out.writeInt(this.sessionAttributeDeltas.size());
                for (Map.Entry<String, Object> entry : this.sessionAttributeDeltas.entrySet()) {
                    out.writeUTF(entry.getKey());
                    this.writeObject(entry.getValue(), out);
                }
                this.clearDelta();
            }
        }

        protected void writeObject(Object value, DataOutput out) throws IOException {
            DataSerializer.writeObject((Object)value, (DataOutput)out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasDelta() {
            Object object = this.getLock();
            synchronized (object) {
                return !this.sessionAttributeDeltas.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fromDelta(DataInput in) throws InvalidDeltaException, IOException {
            Object object = this.getLock();
            synchronized (object) {
                try {
                    int count = in.readInt();
                    HashMap<String, Object> deltas = new HashMap<String, Object>(count);
                    while (count-- > 0) {
                        deltas.put(in.readUTF(), this.readObject(in));
                    }
                    deltas.forEach((key, value) -> {
                        this.setAttribute((String)key, value);
                        this.sessionAttributeDeltas.remove(key);
                    });
                }
                catch (ClassNotFoundException cause) {
                    throw new InvalidDeltaException("Class type in data not found", (Throwable)cause);
                }
            }
        }

        protected <T> T readObject(DataInput in) throws ClassNotFoundException, IOException {
            return (T)DataSerializer.readObject((DataInput)in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearDelta() {
            Object object = this.getLock();
            synchronized (object) {
                this.sessionAttributeDeltas.clear();
            }
        }
    }

    public static class GemFireSession<T extends GemFireSessionAttributes>
    implements Comparable<Session>,
    Session {
        protected static final Duration DEFAULT_MAX_INACTIVE_INTERVAL = Duration.ZERO;
        protected static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
        private transient boolean delta = false;
        private Duration maxInactiveInterval = DEFAULT_MAX_INACTIVE_INTERVAL;
        private Instant creationTime;
        private Instant lastAccessedTime;
        private final transient SpelExpressionParser parser = new SpelExpressionParser();
        private String id;
        private final transient T sessionAttributes = this.newSessionAttributes(this);

        protected GemFireSession() {
            this(GemFireSession.generateId());
        }

        protected GemFireSession(String id) {
            this.id = GemFireSession.validateId(id);
            this.lastAccessedTime = this.creationTime = Instant.now();
        }

        protected GemFireSession(Session session) {
            Assert.notNull((Object)session, (String)"The Session to copy cannot be null");
            this.id = session.getId();
            this.creationTime = session.getCreationTime();
            this.lastAccessedTime = session.getLastAccessedTime();
            this.maxInactiveInterval = session.getMaxInactiveInterval();
            ((GemFireSessionAttributes)this.sessionAttributes).from(session);
        }

        public static GemFireSession copy(Session session) {
            return AbstractGemFireOperationsSessionRepository.isUsingDataSerialization() ? new DeltaCapableGemFireSession(session) : new GemFireSession(session);
        }

        public static GemFireSession create() {
            return GemFireSession.create(DEFAULT_MAX_INACTIVE_INTERVAL);
        }

        public static GemFireSession create(Duration maxInactiveInterval) {
            GemFireSession session = AbstractGemFireOperationsSessionRepository.isUsingDataSerialization() ? new DeltaCapableGemFireSession() : new GemFireSession();
            session.setMaxInactiveInterval(maxInactiveInterval);
            return session;
        }

        public static <T extends GemFireSession> T from(Session session) {
            return (T)(session instanceof GemFireSession ? (GemFireSession)session : GemFireSession.copy(session));
        }

        private static String generateId() {
            return UUID.randomUUID().toString();
        }

        private static String validateId(String id) {
            return Optional.ofNullable(id).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"ID is required", (Object[])new Object[0]));
        }

        protected T newSessionAttributes(Object lock) {
            return (T)new GemFireSessionAttributes(lock);
        }

        public synchronized String changeSessionId() {
            this.id = GemFireSession.generateId();
            this.triggerDelta();
            return this.getId();
        }

        public synchronized void clearDelta() {
            this.delta = false;
        }

        public synchronized boolean hasDelta() {
            return this.delta || ((GemFireSessionAttributes)this.sessionAttributes).hasDelta();
        }

        protected void triggerDelta() {
            this.triggerDelta(true);
        }

        protected synchronized void triggerDelta(boolean condition) {
            this.delta |= condition;
        }

        synchronized void setId(String id) {
            this.id = GemFireSession.validateId(id);
        }

        public synchronized String getId() {
            return this.id;
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            ((GemFireSessionAttributes)this.sessionAttributes).setAttribute(attributeName, attributeValue);
        }

        public void removeAttribute(String attributeName) {
            ((GemFireSessionAttributes)this.sessionAttributes).removeAttribute(attributeName);
        }

        public <T> T getAttribute(String attributeName) {
            return ((GemFireSessionAttributes)this.sessionAttributes).getAttribute(attributeName);
        }

        public Set<String> getAttributeNames() {
            return ((GemFireSessionAttributes)this.sessionAttributes).getAttributeNames();
        }

        public T getAttributes() {
            return this.sessionAttributes;
        }

        public synchronized Instant getCreationTime() {
            return this.creationTime;
        }

        public synchronized boolean isExpired() {
            Instant lastAccessedTime = this.getLastAccessedTime();
            Duration maxInactiveInterval = this.getMaxInactiveInterval();
            return this.isExpirationEnabled(maxInactiveInterval) && Instant.now().minus(maxInactiveInterval).isAfter(lastAccessedTime);
        }

        private boolean isExpirationDisabled(Duration duration) {
            return duration == null || duration.isNegative() || duration.isZero();
        }

        private boolean isExpirationEnabled(Duration duration) {
            return !this.isExpirationDisabled(duration);
        }

        public synchronized void setLastAccessedTime(Instant lastAccessedTime) {
            this.triggerDelta(!ObjectUtils.nullSafeEquals((Object)this.lastAccessedTime, (Object)lastAccessedTime));
            this.lastAccessedTime = lastAccessedTime;
        }

        public synchronized Instant getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public synchronized void setMaxInactiveInterval(Duration maxInactiveIntervalInSeconds) {
            this.triggerDelta(!ObjectUtils.nullSafeEquals((Object)this.maxInactiveInterval, (Object)maxInactiveIntervalInSeconds));
            this.maxInactiveInterval = maxInactiveIntervalInSeconds;
        }

        public synchronized Duration getMaxInactiveInterval() {
            return Optional.ofNullable(this.maxInactiveInterval).orElse(DEFAULT_MAX_INACTIVE_INTERVAL);
        }

        public synchronized void setPrincipalName(String principalName) {
            this.setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, principalName);
        }

        public synchronized String getPrincipalName() {
            T authentication;
            String principalName = (String)this.getAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
            if (principalName == null && (authentication = this.getAttribute(SPRING_SECURITY_CONTEXT)) != null) {
                Expression expression = this.parser.parseExpression("authentication?.name");
                principalName = (String)expression.getValue(authentication, String.class);
            }
            return principalName;
        }

        @Override
        public int compareTo(Session session) {
            return this.getCreationTime().compareTo(session.getCreationTime());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Session)) {
                return false;
            }
            Session that = (Session)obj;
            return this.getId().equals(that.getId());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + this.getId().hashCode();
            return hashValue;
        }

        public synchronized String toString() {
            return String.format("{ @type = %1$s, id = %2$s, creationTime = %3$s, lastAccessedTime = %4$s, maxInactiveInterval = %5$s, principalName = %6$s }", this.getClass().getName(), this.getId(), this.getCreationTime(), this.getLastAccessedTime(), this.getMaxInactiveInterval(), this.getPrincipalName());
        }
    }

    public static class DeltaCapableGemFireSession
    extends GemFireSession<DeltaCapableGemFireSessionAttributes>
    implements Delta {
        public DeltaCapableGemFireSession() {
        }

        public DeltaCapableGemFireSession(String id) {
            super(id);
        }

        public DeltaCapableGemFireSession(Session session) {
            super(session);
        }

        @Override
        protected DeltaCapableGemFireSessionAttributes newSessionAttributes(Object lock) {
            return new DeltaCapableGemFireSessionAttributes();
        }

        public synchronized void toDelta(DataOutput out) throws IOException {
            out.writeUTF(this.getId());
            out.writeLong(this.getLastAccessedTime().toEpochMilli());
            out.writeLong(this.getMaxInactiveInterval().getSeconds());
            ((DeltaCapableGemFireSessionAttributes)this.getAttributes()).toDelta(out);
            this.clearDelta();
        }

        public synchronized void fromDelta(DataInput in) throws IOException {
            this.setId(in.readUTF());
            this.setLastAccessedTime(Instant.ofEpochMilli(in.readLong()));
            this.setMaxInactiveInterval(Duration.ofSeconds(in.readLong()));
            ((DeltaCapableGemFireSessionAttributes)this.getAttributes()).fromDelta(in);
            this.clearDelta();
        }
    }
}

