/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.authentication;

import java.util.HashSet;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.FactorGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialUserEntity;
import org.springframework.security.web.webauthn.authentication.WebAuthnAuthentication;
import org.springframework.security.web.webauthn.authentication.WebAuthnAuthenticationRequestToken;
import org.springframework.security.web.webauthn.management.WebAuthnRelyingPartyOperations;
import org.springframework.util.Assert;

public class WebAuthnAuthenticationProvider
implements AuthenticationProvider {
    private static final String AUTHORITY = "FACTOR_WEBAUTHN";
    private final WebAuthnRelyingPartyOperations relyingPartyOperations;
    private final UserDetailsService userDetailsService;

    public WebAuthnAuthenticationProvider(WebAuthnRelyingPartyOperations relyingPartyOperations, UserDetailsService userDetailsService) {
        Assert.notNull((Object)relyingPartyOperations, (String)"relyingPartyOperations cannot be null");
        Assert.notNull((Object)userDetailsService, (String)"userDetailsService cannot be null");
        this.relyingPartyOperations = relyingPartyOperations;
        this.userDetailsService = userDetailsService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        WebAuthnAuthenticationRequestToken webAuthnRequest = (WebAuthnAuthenticationRequestToken)authentication;
        try {
            PublicKeyCredentialUserEntity userEntity = this.relyingPartyOperations.authenticate(webAuthnRequest.getWebAuthnRequest());
            String username = userEntity.getName();
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
            HashSet<FactorGrantedAuthority> authorities = new HashSet<FactorGrantedAuthority>(userDetails.getAuthorities());
            authorities.add(FactorGrantedAuthority.fromAuthority((String)AUTHORITY));
            return new WebAuthnAuthentication(userEntity, authorities);
        }
        catch (RuntimeException ex) {
            throw new BadCredentialsException(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean supports(Class<?> authentication) {
        return WebAuthnAuthenticationRequestToken.class.isAssignableFrom(authentication);
    }
}

