/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.authentication;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialRequestOptions;
import org.springframework.security.web.webauthn.authentication.HttpSessionPublicKeyCredentialRequestOptionsRepository;
import org.springframework.security.web.webauthn.authentication.PublicKeyCredentialRequestOptionsRepository;
import org.springframework.security.web.webauthn.jackson.WebauthnJacksonModule;
import org.springframework.security.web.webauthn.management.ImmutablePublicKeyCredentialRequestOptionsRequest;
import org.springframework.security.web.webauthn.management.WebAuthnRelyingPartyOperations;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.json.JsonMapper;

public class PublicKeyCredentialRequestOptionsFilter
extends OncePerRequestFilter {
    private RequestMatcher matcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.POST, "/webauthn/authenticate/options");
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private final WebAuthnRelyingPartyOperations rpOptions;
    private PublicKeyCredentialRequestOptionsRepository requestOptionsRepository = new HttpSessionPublicKeyCredentialRequestOptionsRepository();
    private HttpMessageConverter<Object> converter = new JacksonJsonHttpMessageConverter(((JsonMapper.Builder)JsonMapper.builder().addModule((JacksonModule)new WebauthnJacksonModule())).build());

    public PublicKeyCredentialRequestOptionsFilter(WebAuthnRelyingPartyOperations rpOptions) {
        Assert.notNull((Object)rpOptions, (String)"rpOperations cannot be null");
        this.rpOptions = rpOptions;
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.matcher = requestMatcher;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.matcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        SecurityContext context = this.securityContextHolderStrategy.getContext();
        ImmutablePublicKeyCredentialRequestOptionsRequest optionsRequest = new ImmutablePublicKeyCredentialRequestOptionsRequest(context.getAuthentication());
        PublicKeyCredentialRequestOptions credentialRequestOptions = this.rpOptions.createCredentialRequestOptions(optionsRequest);
        this.requestOptionsRepository.save(request, response, credentialRequestOptions);
        response.setHeader("Content-Type", "application/json");
        this.converter.write((Object)credentialRequestOptions, MediaType.APPLICATION_JSON, (HttpOutputMessage)new ServletServerHttpResponse(response));
    }

    public void setRequestOptionsRepository(PublicKeyCredentialRequestOptionsRepository requestOptionsRepository) {
        Assert.notNull((Object)requestOptionsRepository, (String)"requestOptionsRepository cannot be null");
        this.requestOptionsRepository = requestOptionsRepository;
    }

    public void setConverter(HttpMessageConverter<Object> converter) {
        Assert.notNull(converter, (String)"converter cannot be null");
        this.converter = converter;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }
}

