/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util.matcher;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Objects;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class ParameterRequestMatcher
implements RequestMatcher {
    private static final MatchesValueMatcher NON_NULL = Objects::nonNull;
    private final String name;
    private final ValueMatcher matcher;

    public ParameterRequestMatcher(String name) {
        this.name = name;
        this.matcher = NON_NULL;
    }

    public ParameterRequestMatcher(String name, String value) {
        this.name = name;
        MatchesValueMatcher matcher = value::equals;
        if (value.startsWith("{") && value.endsWith("}")) {
            String key = value.substring(1, value.length() - 1);
            this.matcher = v -> v != null ? RequestMatcher.MatchResult.match(Map.of(key, v)) : RequestMatcher.MatchResult.notMatch();
        } else {
            this.matcher = matcher;
        }
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        return this.matcher(request).isMatch();
    }

    @Override
    public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
        String parameterValue = request.getParameter(this.name);
        return this.matcher.matcher(parameterValue);
    }

    private static interface MatchesValueMatcher
    extends ValueMatcher {
        @Override
        default public RequestMatcher.MatchResult matcher(String value) {
            if (this.matches(value)) {
                return RequestMatcher.MatchResult.match();
            }
            return RequestMatcher.MatchResult.notMatch();
        }

        public boolean matches(String var1);
    }

    private static interface ValueMatcher {
        public RequestMatcher.MatchResult matcher(String var1);
    }
}

