/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.context.support;

import java.util.function.Function;
import org.reactivestreams.Subscription;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.test.context.TestSecurityContextHolder;
import org.springframework.security.test.context.support.DelegatingTestExecutionListener;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public class ReactorContextTestExecutionListener
extends DelegatingTestExecutionListener {
    private static final String HOOKS_CLASS_NAME = "reactor.core.publisher.Hooks";

    public ReactorContextTestExecutionListener() {
        super(ReactorContextTestExecutionListener.createDelegate());
    }

    private static TestExecutionListener createDelegate() {
        return ClassUtils.isPresent((String)HOOKS_CLASS_NAME, (ClassLoader)ReactorContextTestExecutionListener.class.getClassLoader()) ? new DelegateTestExecutionListener() : new AbstractTestExecutionListener(){};
    }

    public int getOrder() {
        return 11000;
    }

    private static class DelegateTestExecutionListener
    extends AbstractTestExecutionListener {
        private DelegateTestExecutionListener() {
        }

        public void beforeTestMethod(TestContext testContext) throws Exception {
            SecurityContext securityContext = TestSecurityContextHolder.getContext();
            Hooks.onLastOperator((Function)Operators.lift((s, sub) -> new SecuritySubContext(sub, securityContext)));
        }

        public void afterTestMethod(TestContext testContext) throws Exception {
            Hooks.resetOnLastOperator();
        }

        private static class SecuritySubContext<T>
        implements CoreSubscriber<T> {
            private static String CONTEXT_DEFAULTED_ATTR_NAME = SecuritySubContext.class.getName().concat(".CONTEXT_DEFAULTED_ATTR_NAME");
            private final CoreSubscriber<T> delegate;
            private final SecurityContext securityContext;

            SecuritySubContext(CoreSubscriber<T> delegate, SecurityContext securityContext) {
                this.delegate = delegate;
                this.securityContext = securityContext;
            }

            public Context currentContext() {
                Context context = this.delegate.currentContext();
                if (context.hasKey((Object)CONTEXT_DEFAULTED_ATTR_NAME)) {
                    return context;
                }
                context = context.put((Object)CONTEXT_DEFAULTED_ATTR_NAME, (Object)Boolean.TRUE);
                Authentication authentication = this.securityContext.getAuthentication();
                if (authentication == null) {
                    return context;
                }
                Context toMerge = ReactiveSecurityContextHolder.withSecurityContext((Mono)Mono.just((Object)this.securityContext));
                return toMerge.putAll(context);
            }

            public void onSubscribe(Subscription s) {
                this.delegate.onSubscribe(s);
            }

            public void onNext(T t) {
                this.delegate.onNext(t);
            }

            public void onError(Throwable t) {
                this.delegate.onError(t);
            }

            public void onComplete() {
                this.delegate.onComplete();
            }
        }
    }
}

