/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.servlet.setup;

import javax.servlet.Filter;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurerAdapter;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SecurityMockMvcConfigurer
extends MockMvcConfigurerAdapter {
    private Filter springSecurityFilterChain;

    SecurityMockMvcConfigurer() {
    }

    SecurityMockMvcConfigurer(Filter springSecurityFilterChain) {
        this.springSecurityFilterChain = springSecurityFilterChain;
    }

    public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
        String securityBeanId = "springSecurityFilterChain";
        if (this.springSecurityFilterChain == null && context.containsBean(securityBeanId)) {
            this.springSecurityFilterChain = (Filter)context.getBean(securityBeanId, Filter.class);
        }
        if (this.springSecurityFilterChain == null) {
            throw new IllegalStateException("springSecurityFilterChain cannot be null. Ensure a Bean with the name " + securityBeanId + " implementing Filter is present or inject the Filter to be used.");
        }
        builder.addFilters(new Filter[]{this.springSecurityFilterChain});
        return SecurityMockMvcRequestPostProcessors.testSecurityContext();
    }
}

