/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.springframework.core.serializer.DefaultDeserializer;
import org.springframework.core.serializer.DefaultSerializer;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.security.saml2.provider.service.registration.AssertingPartyMetadata;
import org.springframework.security.saml2.provider.service.registration.AssertingPartyMetadataRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.util.Assert;
import org.springframework.util.function.ThrowingFunction;

public final class JdbcAssertingPartyMetadataRepository
implements AssertingPartyMetadataRepository {
    private final JdbcOperations jdbcOperations;
    private final RowMapper<AssertingPartyMetadata> assertingPartyMetadataRowMapper = new AssertingPartyMetadataRowMapper();
    private final AssertingPartyMetadataParametersMapper assertingPartyMetadataParametersMapper = new AssertingPartyMetadataParametersMapper();
    static final String[] COLUMN_NAMES = new String[]{"entity_id", "single_sign_on_service_location", "single_sign_on_service_binding", "want_authn_requests_signed", "signing_algorithms", "verification_credentials", "encryption_credentials", "single_logout_service_location", "single_logout_service_response_location", "single_logout_service_binding"};
    private static final String TABLE_NAME = "saml2_asserting_party_metadata";
    private static final String ENTITY_ID_FILTER = "entity_id = ?";
    private static final String LOAD_BY_ID_SQL = "SELECT " + String.join((CharSequence)",", COLUMN_NAMES) + " FROM saml2_asserting_party_metadata WHERE entity_id = ?";
    private static final String LOAD_ALL_SQL = "SELECT " + String.join((CharSequence)",", COLUMN_NAMES) + " FROM saml2_asserting_party_metadata";
    private static final String SAVE_CREDENTIAL_RECORD_SQL = "INSERT INTO saml2_asserting_party_metadata (" + String.join((CharSequence)",", COLUMN_NAMES) + ") VALUES (" + String.join((CharSequence)",", Collections.nCopies(COLUMN_NAMES.length, "?")) + ")";
    private static final String UPDATE_CREDENTIAL_RECORD_SQL = "UPDATE saml2_asserting_party_metadata SET " + String.join((CharSequence)" = ?,", Arrays.copyOfRange(COLUMN_NAMES, 1, COLUMN_NAMES.length)) + " = ? WHERE entity_id = ?";

    public JdbcAssertingPartyMetadataRepository(JdbcOperations jdbcOperations) {
        Assert.notNull((Object)jdbcOperations, (String)"jdbcOperations cannot be null");
        this.jdbcOperations = jdbcOperations;
    }

    @Override
    public AssertingPartyMetadata findByEntityId(String entityId) {
        Assert.hasText((String)entityId, (String)"entityId cannot be empty");
        Object[] parameters = new SqlParameterValue[]{new SqlParameterValue(12, (Object)entityId)};
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters);
        List result = this.jdbcOperations.query(LOAD_BY_ID_SQL, (PreparedStatementSetter)pss, this.assertingPartyMetadataRowMapper);
        return !result.isEmpty() ? (AssertingPartyMetadata)result.get(0) : null;
    }

    @Override
    public Iterator<AssertingPartyMetadata> iterator() {
        List result = this.jdbcOperations.query(LOAD_ALL_SQL, this.assertingPartyMetadataRowMapper);
        return result.iterator();
    }

    public void save(AssertingPartyMetadata metadata) {
        Assert.notNull((Object)metadata, (String)"metadata cannot be null");
        int rows = this.updateCredentialRecord(metadata);
        if (rows == 0) {
            this.insertCredentialRecord(metadata);
        }
    }

    private void insertCredentialRecord(AssertingPartyMetadata metadata) {
        List<SqlParameterValue> parameters = this.assertingPartyMetadataParametersMapper.apply(metadata);
        this.jdbcOperations.update(SAVE_CREDENTIAL_RECORD_SQL, parameters.toArray());
    }

    private int updateCredentialRecord(AssertingPartyMetadata metadata) {
        List<SqlParameterValue> parameters = this.assertingPartyMetadataParametersMapper.apply(metadata);
        SqlParameterValue credentialId = parameters.remove(0);
        parameters.add(credentialId);
        return this.jdbcOperations.update(UPDATE_CREDENTIAL_RECORD_SQL, parameters.toArray());
    }

    private static final class AssertingPartyMetadataRowMapper
    implements RowMapper<AssertingPartyMetadata> {
        private final Deserializer<Object> deserializer = new DefaultDeserializer();

        private AssertingPartyMetadataRowMapper() {
        }

        public AssertingPartyMetadata mapRow(ResultSet rs, int rowNum) throws SQLException {
            String entityId = rs.getString(COLUMN_NAMES[0]);
            String singleSignOnUrl = rs.getString(COLUMN_NAMES[1]);
            Saml2MessageBinding singleSignOnBinding = Saml2MessageBinding.from(rs.getString(COLUMN_NAMES[2]));
            boolean singleSignOnSignRequest = rs.getBoolean(COLUMN_NAMES[3]);
            List<String> algorithms = List.of(rs.getString(COLUMN_NAMES[4]).split(","));
            byte[] verificationCredentialsBytes = rs.getBytes(COLUMN_NAMES[5]);
            byte[] encryptionCredentialsBytes = rs.getBytes(COLUMN_NAMES[6]);
            ThrowingFunction credentials = bytes -> (Collection)this.deserializer.deserializeFromByteArray(bytes);
            RelyingPartyRegistration.AssertingPartyDetails.Builder builder = new RelyingPartyRegistration.AssertingPartyDetails.Builder();
            Collection verificationCredentials = (Collection)credentials.apply((Object)verificationCredentialsBytes);
            List encryptionCredentials = encryptionCredentialsBytes != null ? (Collection)credentials.apply((Object)encryptionCredentialsBytes) : List.of();
            String singleLogoutUrl = rs.getString(COLUMN_NAMES[7]);
            String singleLogoutResponseUrl = rs.getString(COLUMN_NAMES[8]);
            Saml2MessageBinding singleLogoutBinding = Saml2MessageBinding.from(rs.getString(COLUMN_NAMES[9]));
            builder.entityId(entityId).wantAuthnRequestsSigned(singleSignOnSignRequest).singleSignOnServiceLocation(singleSignOnUrl).singleSignOnServiceBinding(singleSignOnBinding).singleLogoutServiceLocation(singleLogoutUrl).singleLogoutServiceBinding(singleLogoutBinding).singleLogoutServiceResponseLocation(singleLogoutResponseUrl).signingAlgorithms(a -> a.addAll(algorithms)).verificationX509Credentials(c -> c.addAll(verificationCredentials)).encryptionX509Credentials(c -> c.addAll(encryptionCredentials));
            return builder.build();
        }
    }

    private static class AssertingPartyMetadataParametersMapper
    implements Function<AssertingPartyMetadata, List<SqlParameterValue>> {
        private final Serializer<Object> serializer = new DefaultSerializer();

        private AssertingPartyMetadataParametersMapper() {
        }

        @Override
        public List<SqlParameterValue> apply(AssertingPartyMetadata record) {
            ArrayList<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>();
            parameters.add(new SqlParameterValue(12, (Object)record.getEntityId()));
            parameters.add(new SqlParameterValue(12, (Object)record.getSingleSignOnServiceLocation()));
            parameters.add(new SqlParameterValue(12, (Object)record.getSingleSignOnServiceBinding().getUrn()));
            parameters.add(new SqlParameterValue(16, (Object)record.getWantAuthnRequestsSigned()));
            parameters.add(new SqlParameterValue(2004, (Object)String.join((CharSequence)",", record.getSigningAlgorithms())));
            ThrowingFunction credentials = arg_0 -> this.serializer.serializeToByteArray(arg_0);
            parameters.add(new SqlParameterValue(2004, credentials.apply(record.getVerificationX509Credentials())));
            parameters.add(new SqlParameterValue(2004, credentials.apply(record.getEncryptionX509Credentials())));
            parameters.add(new SqlParameterValue(12, (Object)record.getSingleLogoutServiceLocation()));
            parameters.add(new SqlParameterValue(12, (Object)record.getSingleLogoutServiceResponseLocation()));
            parameters.add(new SqlParameterValue(12, (Object)record.getSingleLogoutServiceBinding().getUrn()));
            return parameters;
        }
    }
}

