/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidatorParameters;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponse;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutValidatorResult;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationPlaceholderResolvers;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestValidatorParametersResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2MessageBindingUtils;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.logout.CompositeLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponentsBuilder;

public final class Saml2LogoutRequestFilter
extends OncePerRequestFilter {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private final Saml2LogoutRequestValidatorParametersResolver logoutRequestResolver;
    private final Saml2LogoutRequestValidator logoutRequestValidator;
    private final Saml2LogoutResponseResolver logoutResponseResolver;
    private final LogoutHandler handler;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public Saml2LogoutRequestFilter(Saml2LogoutRequestValidatorParametersResolver logoutRequestResolver, Saml2LogoutRequestValidator logoutRequestValidator, Saml2LogoutResponseResolver logoutResponseResolver, LogoutHandler ... handlers) {
        this.logoutRequestResolver = logoutRequestResolver;
        this.logoutRequestValidator = logoutRequestValidator;
        this.logoutResponseResolver = logoutResponseResolver;
        this.handler = new CompositeLogoutHandler(handlers);
    }

    public Saml2LogoutRequestFilter(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver, Saml2LogoutRequestValidator logoutRequestValidator, Saml2LogoutResponseResolver logoutResponseResolver, LogoutHandler ... handlers) {
        this.logoutRequestResolver = new Saml2AssertingPartyLogoutRequestResolver(relyingPartyRegistrationResolver);
        this.logoutRequestValidator = logoutRequestValidator;
        this.logoutResponseResolver = logoutResponseResolver;
        this.handler = new CompositeLogoutHandler(handlers);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        Saml2LogoutRequestValidatorParameters parameters;
        Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
        try {
            parameters = this.logoutRequestResolver.resolve(request, authentication);
        }
        catch (Saml2AuthenticationException ex) {
            this.logger.trace((Object)"Did not process logout request since failed to find requested RelyingPartyRegistration");
            response.sendError(400);
            return;
        }
        if (parameters == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        RelyingPartyRegistration registration = parameters.getRelyingPartyRegistration();
        if (registration.getSingleLogoutServiceLocation() == null) {
            this.logger.trace((Object)"Did not process logout request since RelyingPartyRegistration has not been configured with a logout request endpoint");
            response.sendError(401);
            return;
        }
        Saml2MessageBinding saml2MessageBinding = Saml2MessageBindingUtils.resolveBinding(request);
        if (!registration.getSingleLogoutServiceBindings().contains((Object)saml2MessageBinding)) {
            this.logger.trace((Object)"Did not process logout request since used incorrect binding");
            response.sendError(401);
            return;
        }
        Saml2LogoutValidatorResult result = this.logoutRequestValidator.validate(parameters);
        if (result.hasErrors()) {
            response.sendError(401, result.getErrors().iterator().next().toString());
            this.logger.debug((Object)LogMessage.format((String)"Failed to validate LogoutRequest: %s", result.getErrors()));
            return;
        }
        this.handler.logout(request, response, authentication);
        Saml2LogoutResponse logoutResponse = this.logoutResponseResolver.resolve(request, authentication);
        if (logoutResponse == null) {
            this.logger.trace((Object)"Returning 401 since no logout response generated");
            response.setStatus(401);
            return;
        }
        if (logoutResponse.getBinding() == Saml2MessageBinding.REDIRECT) {
            this.doRedirect(request, response, logoutResponse);
        } else {
            this.doPost(response, logoutResponse);
        }
    }

    public void setLogoutRequestMatcher(RequestMatcher logoutRequestMatcher) {
        Assert.notNull((Object)logoutRequestMatcher, (String)"logoutRequestMatcher cannot be null");
        Assert.isInstanceOf(Saml2AssertingPartyLogoutRequestResolver.class, (Object)this.logoutRequestResolver, (String)"saml2LogoutRequestResolver and logoutRequestMatcher cannot both be set. Please set the request matcher in the saml2LogoutRequestResolver itself.");
        ((Saml2AssertingPartyLogoutRequestResolver)this.logoutRequestResolver).setLogoutRequestMatcher(logoutRequestMatcher);
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    private void doRedirect(HttpServletRequest request, HttpServletResponse response, Saml2LogoutResponse logoutResponse) throws IOException {
        String location = logoutResponse.getResponseLocation();
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)location).query(logoutResponse.getParametersQuery());
        this.redirectStrategy.sendRedirect(request, response, uriBuilder.build(true).toUriString());
    }

    private void doPost(HttpServletResponse response, Saml2LogoutResponse logoutResponse) throws IOException {
        String location = logoutResponse.getResponseLocation();
        String saml = logoutResponse.getSamlResponse();
        String relayState = logoutResponse.getRelayState();
        String html = this.createSamlPostRequestFormData(location, saml, relayState);
        response.setContentType("text/html");
        response.getWriter().write(html);
    }

    private String createSamlPostRequestFormData(String location, String saml, String relayState) {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html>\n");
        html.append("<html>\n").append("    <head>\n");
        html.append("        <meta http-equiv=\"Content-Security-Policy\" ").append("content=\"script-src 'sha256-oZhLbc2kO8b8oaYLrUc7uye1MgVKMyLtPqWR4WtKF+c='\">\n");
        html.append("        <meta charset=\"utf-8\" />\n");
        html.append("    </head>\n");
        html.append("    <body>\n");
        html.append("        <noscript>\n");
        html.append("            <p>\n");
        html.append("                <strong>Note:</strong> Since your browser does not support JavaScript,\n");
        html.append("                you must press the Continue button once to proceed.\n");
        html.append("            </p>\n");
        html.append("        </noscript>\n");
        html.append("        \n");
        html.append("        <form action=\"");
        html.append(location);
        html.append("\" method=\"post\">\n");
        html.append("            <div>\n");
        html.append("                <input type=\"hidden\" name=\"SAMLResponse\" value=\"");
        html.append(HtmlUtils.htmlEscape((String)saml));
        html.append("\"/>\n");
        if (StringUtils.hasText((String)relayState)) {
            html.append("                <input type=\"hidden\" name=\"RelayState\" value=\"");
            html.append(HtmlUtils.htmlEscape((String)relayState));
            html.append("\"/>\n");
        }
        html.append("            </div>\n");
        html.append("            <noscript>\n");
        html.append("                <div>\n");
        html.append("                    <input type=\"submit\" value=\"Continue\"/>\n");
        html.append("                </div>\n");
        html.append("            </noscript>\n");
        html.append("        </form>\n");
        html.append("        \n");
        html.append("        <script>window.onload = function() { document.forms[0].submit(); }</script>\n");
        html.append("    </body>\n");
        html.append("</html>");
        return html.toString();
    }

    private static class Saml2AssertingPartyLogoutRequestResolver
    implements Saml2LogoutRequestValidatorParametersResolver {
        private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;
        private RequestMatcher logoutRequestMatcher = new AntPathRequestMatcher("/logout/saml2/slo");

        Saml2AssertingPartyLogoutRequestResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
            this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        }

        @Override
        public Saml2LogoutRequestValidatorParameters resolve(HttpServletRequest request, Authentication authentication) {
            String serialized = request.getParameter("SAMLRequest");
            if (serialized == null) {
                return null;
            }
            RequestMatcher.MatchResult result = this.logoutRequestMatcher.matcher(request);
            if (!result.isMatch()) {
                return null;
            }
            String registrationId = this.getRegistrationId(result, authentication);
            RelyingPartyRegistration registration = this.relyingPartyRegistrationResolver.resolve(request, registrationId);
            if (registration == null) {
                throw new Saml2AuthenticationException(new Saml2Error("relying_party_registration_not_found", "registration not found"), "registration not found");
            }
            RelyingPartyRegistrationPlaceholderResolvers.UriResolver uriResolver = RelyingPartyRegistrationPlaceholderResolvers.uriResolver(request, registration);
            String entityId = uriResolver.resolve(registration.getEntityId());
            String logoutLocation = uriResolver.resolve(registration.getSingleLogoutServiceLocation());
            String logoutResponseLocation = uriResolver.resolve(registration.getSingleLogoutServiceResponseLocation());
            registration = registration.mutate().entityId(entityId).singleLogoutServiceLocation(logoutLocation).singleLogoutServiceResponseLocation(logoutResponseLocation).build();
            Saml2MessageBinding saml2MessageBinding = Saml2MessageBindingUtils.resolveBinding(request);
            Saml2LogoutRequest logoutRequest = Saml2LogoutRequest.withRelyingPartyRegistration(registration).samlRequest(serialized).relayState(request.getParameter("RelayState")).binding(saml2MessageBinding).location(registration.getSingleLogoutServiceLocation()).parameters(params -> params.put("SigAlg", request.getParameter("SigAlg"))).parameters(params -> params.put("Signature", request.getParameter("Signature"))).parametersQuery(params -> request.getQueryString()).build();
            return new Saml2LogoutRequestValidatorParameters(logoutRequest, registration, authentication);
        }

        void setLogoutRequestMatcher(RequestMatcher logoutRequestMatcher) {
            Assert.notNull((Object)logoutRequestMatcher, (String)"logoutRequestMatcher cannot be null");
            this.logoutRequestMatcher = logoutRequestMatcher;
        }

        private String getRegistrationId(RequestMatcher.MatchResult result, Authentication authentication) {
            String registrationId = (String)result.getVariables().get("registrationId");
            if (registrationId != null) {
                return registrationId;
            }
            if (authentication == null) {
                return null;
            }
            Object object = authentication.getPrincipal();
            if (object instanceof Saml2AuthenticatedPrincipal) {
                Saml2AuthenticatedPrincipal principal = (Saml2AuthenticatedPrincipal)object;
                return principal.getRelyingPartyRegistrationId();
            }
            return null;
        }
    }
}

