/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.security.MessageDigest;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestRepository;
import org.springframework.util.Assert;

public final class HttpSessionLogoutRequestRepository
implements Saml2LogoutRequestRepository {
    private static final String DEFAULT_LOGOUT_REQUEST_ATTR_NAME = HttpSessionLogoutRequestRepository.class.getName() + ".LOGOUT_REQUEST";

    @Override
    public Saml2LogoutRequest loadLogoutRequest(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        Saml2LogoutRequest logoutRequest = (Saml2LogoutRequest)session.getAttribute(DEFAULT_LOGOUT_REQUEST_ATTR_NAME);
        if (this.stateParameterEquals(request, logoutRequest)) {
            return logoutRequest;
        }
        return null;
    }

    @Override
    public void saveLogoutRequest(Saml2LogoutRequest logoutRequest, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        Assert.notNull((Object)response, (String)"response cannot be null");
        if (logoutRequest == null) {
            request.getSession().removeAttribute(DEFAULT_LOGOUT_REQUEST_ATTR_NAME);
            return;
        }
        String state = logoutRequest.getRelayState();
        Assert.hasText((String)state, (String)"logoutRequest.state cannot be empty");
        request.getSession().setAttribute(DEFAULT_LOGOUT_REQUEST_ATTR_NAME, (Object)logoutRequest);
    }

    @Override
    public Saml2LogoutRequest removeLogoutRequest(HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        Assert.notNull((Object)response, (String)"response cannot be null");
        Saml2LogoutRequest logoutRequest = this.loadLogoutRequest(request);
        if (logoutRequest == null) {
            return null;
        }
        request.getSession().removeAttribute(DEFAULT_LOGOUT_REQUEST_ATTR_NAME);
        return logoutRequest;
    }

    private String getStateParameter(HttpServletRequest request) {
        return request.getParameter("RelayState");
    }

    private boolean stateParameterEquals(HttpServletRequest request, Saml2LogoutRequest logoutRequest) {
        String stateParameter = this.getStateParameter(request);
        if (stateParameter == null || logoutRequest == null) {
            return false;
        }
        String relayState = logoutRequest.getRelayState();
        return MessageDigest.isEqual(Utf8.encode((CharSequence)stateParameter), Utf8.encode((CharSequence)relayState));
    }
}

