/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.OpenSamlAssertingPartyDetails;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class OpenSamlMetadataAssertingPartyDetailsConverter {
    private final XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
    private final ParserPool parserPool = this.registry.getParserPool();

    OpenSamlMetadataAssertingPartyDetailsConverter() {
    }

    Collection<RelyingPartyRegistration.AssertingPartyDetails.Builder> convert(InputStream inputStream) {
        ArrayList<RelyingPartyRegistration.AssertingPartyDetails.Builder> builders = new ArrayList<RelyingPartyRegistration.AssertingPartyDetails.Builder>();
        XMLObject xmlObject = this.xmlObject(inputStream);
        if (xmlObject instanceof EntitiesDescriptor) {
            EntitiesDescriptor descriptors = (EntitiesDescriptor)xmlObject;
            for (EntityDescriptor descriptor : descriptors.getEntityDescriptors()) {
                builders.add(this.convert(descriptor));
            }
            return builders;
        }
        if (xmlObject instanceof EntityDescriptor) {
            EntityDescriptor descriptor = (EntityDescriptor)xmlObject;
            return Arrays.asList(this.convert(descriptor));
        }
        throw new Saml2Exception("Unsupported element of type " + xmlObject.getClass());
    }

    RelyingPartyRegistration.AssertingPartyDetails.Builder convert(EntityDescriptor descriptor) {
        Saml2MessageBinding binding;
        IDPSSODescriptor idpssoDescriptor = descriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpssoDescriptor == null) {
            throw new Saml2Exception("Metadata response is missing the necessary IDPSSODescriptor element");
        }
        ArrayList<Saml2X509Credential> verification = new ArrayList<Saml2X509Credential>();
        ArrayList<Saml2X509Credential> encryption = new ArrayList<Saml2X509Credential>();
        for (KeyDescriptor keyDescriptor : idpssoDescriptor.getKeyDescriptors()) {
            List<X509Certificate> certificates;
            if (keyDescriptor.getUse().equals((Object)UsageType.SIGNING)) {
                certificates = this.certificates(keyDescriptor);
                for (X509Certificate certificate : certificates) {
                    verification.add(Saml2X509Credential.verification(certificate));
                }
            }
            if (keyDescriptor.getUse().equals((Object)UsageType.ENCRYPTION)) {
                certificates = this.certificates(keyDescriptor);
                for (X509Certificate certificate : certificates) {
                    encryption.add(Saml2X509Credential.encryption(certificate));
                }
            }
            if (!keyDescriptor.getUse().equals((Object)UsageType.UNSPECIFIED)) continue;
            certificates = this.certificates(keyDescriptor);
            for (X509Certificate certificate : certificates) {
                verification.add(Saml2X509Credential.verification(certificate));
                encryption.add(Saml2X509Credential.encryption(certificate));
            }
        }
        if (verification.isEmpty()) {
            throw new Saml2Exception("Metadata response is missing verification certificates, necessary for verifying SAML assertions");
        }
        RelyingPartyRegistration.AssertingPartyDetails.Builder party = OpenSamlAssertingPartyDetails.withEntityDescriptor(descriptor).entityId(descriptor.getEntityID()).wantAuthnRequestsSigned(Boolean.TRUE.equals(idpssoDescriptor.getWantAuthnRequestsSigned())).verificationX509Credentials(c -> c.addAll(verification)).encryptionX509Credentials(c -> c.addAll(encryption));
        List<SigningMethod> signingMethods = this.signingMethods(idpssoDescriptor);
        for (SigningMethod method : signingMethods) {
            party.signingAlgorithms(algorithms -> algorithms.add(method.getAlgorithm()));
        }
        if (idpssoDescriptor.getSingleSignOnServices().isEmpty()) {
            throw new Saml2Exception("Metadata response is missing a SingleSignOnService, necessary for sending AuthnRequests");
        }
        for (SingleSignOnService singleSignOnService : idpssoDescriptor.getSingleSignOnServices()) {
            if (singleSignOnService.getBinding().equals(Saml2MessageBinding.POST.getUrn())) {
                binding = Saml2MessageBinding.POST;
            } else {
                if (!singleSignOnService.getBinding().equals(Saml2MessageBinding.REDIRECT.getUrn())) continue;
                binding = Saml2MessageBinding.REDIRECT;
            }
            party.singleSignOnServiceLocation(singleSignOnService.getLocation()).singleSignOnServiceBinding(binding);
            break;
        }
        for (SingleLogoutService singleLogoutService : idpssoDescriptor.getSingleLogoutServices()) {
            if (singleLogoutService.getBinding().equals(Saml2MessageBinding.POST.getUrn())) {
                binding = Saml2MessageBinding.POST;
            } else {
                if (!singleLogoutService.getBinding().equals(Saml2MessageBinding.REDIRECT.getUrn())) continue;
                binding = Saml2MessageBinding.REDIRECT;
            }
            String responseLocation = singleLogoutService.getResponseLocation() == null ? singleLogoutService.getLocation() : singleLogoutService.getResponseLocation();
            party.singleLogoutServiceLocation(singleLogoutService.getLocation()).singleLogoutServiceResponseLocation(responseLocation).singleLogoutServiceBinding(binding);
            break;
        }
        return party;
    }

    private List<X509Certificate> certificates(KeyDescriptor keyDescriptor) {
        try {
            return KeyInfoSupport.getCertificates((KeyInfo)keyDescriptor.getKeyInfo());
        }
        catch (CertificateException ex) {
            throw new Saml2Exception(ex);
        }
    }

    private List<SigningMethod> signingMethods(IDPSSODescriptor idpssoDescriptor) {
        Extensions extensions = idpssoDescriptor.getExtensions();
        List<SigningMethod> result = this.signingMethods(extensions);
        if (!result.isEmpty()) {
            return result;
        }
        EntityDescriptor descriptor = (EntityDescriptor)idpssoDescriptor.getParent();
        extensions = descriptor.getExtensions();
        return this.signingMethods(extensions);
    }

    private XMLObject xmlObject(InputStream inputStream) {
        Document document = this.document(inputStream);
        Element element = document.getDocumentElement();
        Unmarshaller unmarshaller = this.registry.getUnmarshallerFactory().getUnmarshaller(element);
        if (unmarshaller == null) {
            throw new Saml2Exception("Unsupported element of type " + element.getTagName());
        }
        try {
            return unmarshaller.unmarshall(element);
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    private Document document(InputStream inputStream) {
        try {
            return this.parserPool.parse(inputStream);
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    private <T> List<T> signingMethods(Extensions extensions) {
        if (extensions != null) {
            return extensions.getUnknownXMLObjects(SigningMethod.DEFAULT_ELEMENT_NAME);
        }
        return new ArrayList();
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

