/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponse;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponseValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponseValidatorParameters;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutValidatorResult;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.HttpSessionLogoutRequestRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestRepository;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public final class Saml2LogoutResponseFilter
extends OncePerRequestFilter {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;
    private final Saml2LogoutResponseValidator logoutResponseValidator;
    private final LogoutSuccessHandler logoutSuccessHandler;
    private Saml2LogoutRequestRepository logoutRequestRepository = new HttpSessionLogoutRequestRepository();
    private RequestMatcher logoutRequestMatcher = new AntPathRequestMatcher("/logout/saml2/slo");

    public Saml2LogoutResponseFilter(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver, Saml2LogoutResponseValidator logoutResponseValidator, LogoutSuccessHandler logoutSuccessHandler) {
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        this.logoutResponseValidator = logoutResponseValidator;
        this.logoutSuccessHandler = logoutSuccessHandler;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!this.logoutRequestMatcher.matches(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getParameter("SAMLResponse") == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Saml2LogoutRequest logoutRequest = this.logoutRequestRepository.removeLogoutRequest(request, response);
        if (logoutRequest == null) {
            this.logger.trace((Object)"Did not process logout response since could not find associated LogoutRequest");
            response.sendError(400, "Failed to find associated LogoutRequest");
            return;
        }
        RelyingPartyRegistration registration = this.relyingPartyRegistrationResolver.resolve(request, logoutRequest.getRelyingPartyRegistrationId());
        if (registration == null) {
            this.logger.trace((Object)"Did not process logout response since failed to find associated RelyingPartyRegistration");
            Saml2Error error = new Saml2Error("relying_party_registration_not_found", "Failed to find associated RelyingPartyRegistration");
            response.sendError(400, error.toString());
            return;
        }
        if (registration.getSingleLogoutServiceResponseLocation() == null) {
            this.logger.trace((Object)"Did not process logout response since RelyingPartyRegistration has not been configured with a logout response endpoint");
            response.sendError(401);
            return;
        }
        if (!this.isCorrectBinding(request, registration)) {
            this.logger.trace((Object)"Did not process logout request since used incorrect binding");
            response.sendError(401);
            return;
        }
        String serialized = request.getParameter("SAMLResponse");
        Saml2LogoutResponse logoutResponse = Saml2LogoutResponse.withRelyingPartyRegistration(registration).samlResponse(serialized).relayState(request.getParameter("RelayState")).binding(registration.getSingleLogoutServiceBinding()).location(registration.getSingleLogoutServiceResponseLocation()).parameters(params -> params.put("SigAlg", request.getParameter("SigAlg"))).parameters(params -> params.put("Signature", request.getParameter("Signature"))).build();
        Saml2LogoutResponseValidatorParameters parameters = new Saml2LogoutResponseValidatorParameters(logoutResponse, logoutRequest, registration);
        Saml2LogoutValidatorResult result = this.logoutResponseValidator.validate(parameters);
        if (result.hasErrors()) {
            response.sendError(401, result.getErrors().iterator().next().toString());
            this.logger.debug((Object)LogMessage.format((String)"Failed to validate LogoutResponse: %s", result.getErrors()));
            return;
        }
        this.logoutSuccessHandler.onLogoutSuccess(request, response, null);
    }

    public void setLogoutRequestMatcher(RequestMatcher logoutRequestMatcher) {
        Assert.notNull((Object)logoutRequestMatcher, (String)"logoutRequestMatcher cannot be null");
        this.logoutRequestMatcher = logoutRequestMatcher;
    }

    public void setLogoutRequestRepository(Saml2LogoutRequestRepository logoutRequestRepository) {
        Assert.notNull((Object)logoutRequestRepository, (String)"logoutRequestRepository cannot be null");
        this.logoutRequestRepository = logoutRequestRepository;
    }

    private boolean isCorrectBinding(HttpServletRequest request, RelyingPartyRegistration registration) {
        Saml2MessageBinding requiredBinding = registration.getSingleLogoutServiceBinding();
        if (requiredBinding == Saml2MessageBinding.POST) {
            return "POST".equals(request.getMethod());
        }
        return "GET".equals(request.getMethod());
    }
}

