/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.binary.Base64;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.Assert;

public final class Saml2AuthenticationTokenConverter
implements AuthenticationConverter {
    private static Base64 BASE64 = new Base64(0, new byte[]{10}, false, CodecPolicy.STRICT);
    private final Converter<HttpServletRequest, RelyingPartyRegistration> relyingPartyRegistrationResolver;
    private Function<HttpServletRequest, AbstractSaml2AuthenticationRequest> loader;

    @Deprecated
    public Saml2AuthenticationTokenConverter(Converter<HttpServletRequest, RelyingPartyRegistration> relyingPartyRegistrationResolver) {
        Assert.notNull(relyingPartyRegistrationResolver, (String)"relyingPartyRegistrationResolver cannot be null");
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        this.loader = new HttpSessionSaml2AuthenticationRequestRepository()::loadAuthenticationRequest;
    }

    public Saml2AuthenticationTokenConverter(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        this(Saml2AuthenticationTokenConverter.adaptToConverter(relyingPartyRegistrationResolver));
    }

    private static Converter<HttpServletRequest, RelyingPartyRegistration> adaptToConverter(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        Assert.notNull((Object)relyingPartyRegistrationResolver, (String)"relyingPartyRegistrationResolver cannot be null");
        return request -> relyingPartyRegistrationResolver.resolve((HttpServletRequest)request, null);
    }

    public Saml2AuthenticationToken convert(HttpServletRequest request) {
        RelyingPartyRegistration relyingPartyRegistration = (RelyingPartyRegistration)this.relyingPartyRegistrationResolver.convert((Object)request);
        if (relyingPartyRegistration == null) {
            return null;
        }
        String saml2Response = request.getParameter("SAMLResponse");
        if (saml2Response == null) {
            return null;
        }
        byte[] b = this.samlDecode(saml2Response);
        saml2Response = this.inflateIfRequired(request, b);
        AbstractSaml2AuthenticationRequest authenticationRequest = this.loadAuthenticationRequest(request);
        return new Saml2AuthenticationToken(relyingPartyRegistration, saml2Response, authenticationRequest);
    }

    public void setAuthenticationRequestRepository(Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository) {
        Assert.notNull(authenticationRequestRepository, (String)"authenticationRequestRepository cannot be null");
        this.loader = authenticationRequestRepository::loadAuthenticationRequest;
    }

    private AbstractSaml2AuthenticationRequest loadAuthenticationRequest(HttpServletRequest request) {
        return this.loader.apply(request);
    }

    private String inflateIfRequired(HttpServletRequest request, byte[] b) {
        if (HttpMethod.GET.matches(request.getMethod())) {
            return this.samlInflate(b);
        }
        return new String(b, StandardCharsets.UTF_8);
    }

    private byte[] samlDecode(String base64EncodedPayload) {
        try {
            return BASE64.decode(base64EncodedPayload);
        }
        catch (Exception ex) {
            throw new Saml2AuthenticationException(new Saml2Error("invalid_response", "Failed to decode SAMLResponse"), (Throwable)ex);
        }
    }

    private String samlInflate(byte[] b) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InflaterOutputStream inflaterOutputStream = new InflaterOutputStream(out, new Inflater(true));
            inflaterOutputStream.write(b);
            inflaterOutputStream.finish();
            return out.toString(StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            throw new Saml2AuthenticationException(new Saml2Error("invalid_response", "Unable to inflate string"), (Throwable)ex);
        }
    }
}

