/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestContext;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

public class Saml2RedirectAuthenticationRequest
extends AbstractSaml2AuthenticationRequest {
    private final String sigAlg;
    private final String signature;

    private Saml2RedirectAuthenticationRequest(String samlRequest, String sigAlg, String signature, String relayState, String authenticationRequestUri) {
        super(samlRequest, relayState, authenticationRequestUri);
        this.sigAlg = sigAlg;
        this.signature = signature;
    }

    public String getSigAlg() {
        return this.sigAlg;
    }

    public String getSignature() {
        return this.signature;
    }

    @Override
    public Saml2MessageBinding getBinding() {
        return Saml2MessageBinding.REDIRECT;
    }

    public static Builder withAuthenticationRequestContext(Saml2AuthenticationRequestContext context) {
        return (Builder)((Builder)new Builder().authenticationRequestUri(context.getDestination())).relayState(context.getRelayState());
    }

    public static class Builder
    extends AbstractSaml2AuthenticationRequest.Builder<Builder> {
        private String sigAlg;
        private String signature;

        private Builder() {
        }

        public Builder sigAlg(String sigAlg) {
            this.sigAlg = sigAlg;
            return (Builder)this._this();
        }

        public Builder signature(String signature) {
            this.signature = signature;
            return (Builder)this._this();
        }

        public Saml2RedirectAuthenticationRequest build() {
            return new Saml2RedirectAuthenticationRequest(this.samlRequest, this.sigAlg, this.signature, this.relayState, this.authenticationRequestUri);
        }
    }
}

